/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.RequestDto;
import org.camunda.bpm.client.interceptor.impl.RequestInterceptorHandler;

public class RequestExecutor {
    protected static final EngineClientLogger LOG = ExternalTaskClientLogger.ENGINE_CLIENT_LOGGER;
    protected static final Header HEADER_CONTENT_TYPE_JSON = new BasicHeader("Content-Type", "application/json");
    protected static final Header HEADER_USER_AGENT = new BasicHeader("User-Agent", "Camunda External Task Client");
    protected HttpClient httpClient;
    protected ObjectMapper objectMapper;

    protected RequestExecutor(RequestInterceptorHandler requestInterceptorHandler, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.initHttpClient(requestInterceptorHandler);
    }

    protected <T> T postRequest(String resourceUrl, RequestDto requestDto, Class<T> responseDtoClass) throws EngineClientException {
        ByteArrayEntity serializedRequest = this.serializeRequest(requestDto);
        HttpUriRequest httpRequest = RequestBuilder.post((String)resourceUrl).addHeader(HEADER_USER_AGENT).addHeader(HEADER_CONTENT_TYPE_JSON).setEntity((HttpEntity)serializedRequest).build();
        return this.executeRequest(httpRequest, responseDtoClass);
    }

    protected <T> T executeRequest(HttpUriRequest httpRequest, Class<T> responseDtoClass) throws EngineClientException {
        try {
            return (T)this.httpClient.execute(httpRequest, this.handleResponse(responseDtoClass));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EngineClientException) {
                throw (EngineClientException)e.getCause();
            }
            throw e;
        }
        catch (HttpResponseException e) {
            throw LOG.exceptionWhileReceivingResponse((HttpRequest)httpRequest, e);
        }
        catch (ClientProtocolException e) {
            throw LOG.exceptionWhileEstablishingConnection((HttpRequest)httpRequest, (IOException)((Object)e));
        }
        catch (IOException e) {
            throw LOG.exceptionWhileEstablishingConnection((HttpRequest)httpRequest, e);
        }
    }

    protected <T> ResponseHandler<T> handleResponse(final Class<T> responseDtoClass) {
        return new AbstractResponseHandler<T>(){

            public T handleEntity(HttpEntity responseEntity) {
                Object deserializedResponse = null;
                if (!responseDtoClass.isAssignableFrom(Void.class)) {
                    try {
                        deserializedResponse = RequestExecutor.this.deserializeResponse(responseEntity, responseDtoClass);
                    }
                    catch (EngineClientException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
                catch (IOException e) {
                    LOG.exceptionWhileClosingResourceStream(deserializedResponse, e);
                }
                return deserializedResponse;
            }
        };
    }

    protected <T> T deserializeResponse(HttpEntity httpEntity, Class<T> responseDtoClass) throws EngineClientException {
        try {
            InputStream responseBody = httpEntity.getContent();
            return (T)this.objectMapper.readValue(responseBody, responseDtoClass);
        }
        catch (JsonParseException e) {
            throw LOG.exceptionWhileParsingJsonObject(responseDtoClass, e);
        }
        catch (JsonMappingException e) {
            throw LOG.exceptionWhileMappingJsonObject(responseDtoClass, e);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileDeserializingJsonObject(responseDtoClass, e);
        }
    }

    protected ByteArrayEntity serializeRequest(RequestDto dto) throws EngineClientException {
        byte[] serializedRequest = null;
        try {
            serializedRequest = this.objectMapper.writeValueAsBytes((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw LOG.exceptionWhileSerializingJsonObject(dto, e);
        }
        ByteArrayEntity byteArrayEntity = null;
        if (serializedRequest != null) {
            byteArrayEntity = new ByteArrayEntity(serializedRequest);
        }
        return byteArrayEntity;
    }

    protected void initHttpClient(RequestInterceptorHandler requestInterceptorHandler) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorLast((HttpRequestInterceptor)requestInterceptorHandler);
        this.httpClient = httpClientBuilder.build();
    }
}

