/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpResponseException;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.RequestDto;

public class EngineClientLogger
extends ExternalTaskClientLogger {
    protected EngineClientException exceptionWhileReceivingResponse(HttpRequest httpRequest, HttpResponseException e) {
        return new EngineClientException(this.exceptionMessage("001", "Request '{}' returned error: status code '{}' - message: {}", new Object[]{httpRequest, e.getStatusCode(), e.getMessage()}), e);
    }

    protected EngineClientException exceptionWhileEstablishingConnection(HttpRequest httpRequest, IOException e) {
        return new EngineClientException(this.exceptionMessage("002", "Exception while establishing connection for request '{}'", new Object[]{httpRequest}), e);
    }

    protected <T> void exceptionWhileClosingResourceStream(T response, IOException e) {
        this.logError("003", "Exception while closing resource stream of response '{}': {}", new Object[]{response, e});
    }

    protected <T> EngineClientException exceptionWhileParsingJsonObject(Class<T> responseDtoClass) {
        return new EngineClientException(this.exceptionMessage("004", "Exception while parsing json object to response dto class '{}'", new Object[]{responseDtoClass}));
    }

    protected <T> EngineClientException exceptionWhileMappingJsonObject(Class<T> responseDtoClass) {
        return new EngineClientException(this.exceptionMessage("005", "Exception while mapping json object to response dto class '{}'", new Object[]{responseDtoClass}));
    }

    protected <T> EngineClientException exceptionWhileDeserializingJsonObject(Class<T> responseDtoClass) {
        return new EngineClientException(this.exceptionMessage("006", "Exception while deserializing json object to response dto class '{}'", new Object[]{responseDtoClass}));
    }

    protected <D extends RequestDto> EngineClientException exceptionWhileSerializingJsonObject(D dto) {
        return new EngineClientException(this.exceptionMessage("007", "Exception while serializing json object to '{}'", new Object[]{dto}));
    }

    public void requestInterceptorException(Throwable e) {
        this.logError("008", "Exception while executing request interceptor: {}", new Object[]{e});
    }

    public EngineClientException exceptionWhileDeserializingVariables(String variableName, String variableType) {
        return new EngineClientException(this.exceptionMessage("009", "Exception while deserializing variable {}: no suitable mapper found for type {}", new Object[]{variableName, variableType}));
    }

    public EngineClientException exceptionWhileDeserializingVariablesWrongType(String variableName, String variableType) {
        return new EngineClientException(this.exceptionMessage("010", "Exception while deserializing variable {}: value does not match to the type {}", new Object[]{variableName, variableType}));
    }
}

