/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.ExternalTaskClientBuilder;
import org.camunda.bpm.client.impl.ExternalTaskClientImpl;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;

public class ExternalTaskClientBuilderImpl
implements ExternalTaskClientBuilder {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String baseUrl;
    protected String workerId;
    protected List<ClientRequestInterceptor> interceptors = new ArrayList<ClientRequestInterceptor>();

    @Override
    public ExternalTaskClientBuilder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public ExternalTaskClientBuilder addInterceptor(ClientRequestInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public ExternalTaskClient build() {
        if (this.baseUrl == null || this.baseUrl.isEmpty()) {
            throw LOG.baseUrlNullException();
        }
        this.checkInterceptors();
        String hostname = this.checkHostname();
        this.workerId = hostname + UUID.randomUUID();
        return new ExternalTaskClientImpl(this);
    }

    protected void checkInterceptors() {
        this.interceptors.forEach(interceptor -> {
            if (interceptor == null) {
                throw LOG.interceptorNullException();
            }
        });
    }

    public String checkHostname() {
        String hostname;
        try {
            hostname = this.getHostname();
        }
        catch (UnknownHostException e) {
            throw LOG.cannotGetHostnameException();
        }
        return hostname;
    }

    public String getHostname() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected String getWorkerId() {
        return this.workerId;
    }

    protected List<ClientRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

