/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.ExternalTaskClientBuilderImpl;
import org.camunda.bpm.client.impl.variable.VariableMappers;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;
import org.camunda.bpm.client.interceptor.impl.RequestInterceptorHandler;
import org.camunda.bpm.client.topic.TopicSubscriptionBuilder;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionBuilderImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManager;

public class ExternalTaskClientImpl
implements ExternalTaskClient {
    protected TopicSubscriptionManager topicSubscriptionManager;
    protected RequestInterceptorHandler requestInterceptorHandler;

    protected ExternalTaskClientImpl(ExternalTaskClientBuilderImpl clientBuilder) {
        String workerId = clientBuilder.getWorkerId();
        String baseUrl = clientBuilder.getBaseUrl();
        List<ClientRequestInterceptor> interceptors = clientBuilder.getInterceptors();
        this.requestInterceptorHandler = new RequestInterceptorHandler(interceptors);
        ObjectMapper objectMapper = this.initObjectMapper();
        VariableMappers variableMappers = new VariableMappers(objectMapper);
        EngineClient engineClient = new EngineClient(workerId, baseUrl, this.requestInterceptorHandler, variableMappers, objectMapper);
        this.topicSubscriptionManager = new TopicSubscriptionManager(engineClient, variableMappers);
    }

    @Override
    public TopicSubscriptionBuilder subscribe(String topicName) {
        return new TopicSubscriptionBuilderImpl(topicName, this.topicSubscriptionManager);
    }

    @Override
    public void stop() {
        this.topicSubscriptionManager.stop();
    }

    public TopicSubscriptionManager getTopicSubscriptionManager() {
        return this.topicSubscriptionManager;
    }

    public RequestInterceptorHandler getRequestInterceptorHandler() {
        return this.requestInterceptorHandler;
    }

    protected ObjectMapper initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        return objectMapper;
    }
}

