/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.camunda.bpm.client.exception.ConnectionLostException;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.exception.NotAcquiredException;
import org.camunda.bpm.client.exception.NotFoundException;
import org.camunda.bpm.client.exception.NotResumedException;
import org.camunda.bpm.client.exception.UnsupportedTypeException;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManagerLogger;
import org.camunda.commons.logging.BaseLogger;

public class ExternalTaskClientLogger
extends BaseLogger {
    protected static final String PROJECT_CODE = "CAMUNDA_EXTERNAL_TASK_CLIENT";
    protected static final String PROJECT_LOGGER = "org.camunda.bpm.client";
    public static final ExternalTaskClientLogger CLIENT_LOGGER = (ExternalTaskClientLogger)ExternalTaskClientLogger.createLogger(ExternalTaskClientLogger.class, (String)"CAMUNDA_EXTERNAL_TASK_CLIENT", (String)"org.camunda.bpm.client", (String)"01");
    public static final EngineClientLogger ENGINE_CLIENT_LOGGER = (EngineClientLogger)ExternalTaskClientLogger.createLogger(EngineClientLogger.class, (String)"CAMUNDA_EXTERNAL_TASK_CLIENT", (String)"org.camunda.bpm.client", (String)"02");
    public static final TopicSubscriptionManagerLogger TOPIC_SUBSCRIPTION_MANAGER_LOGGER = (TopicSubscriptionManagerLogger)ExternalTaskClientLogger.createLogger(TopicSubscriptionManagerLogger.class, (String)"CAMUNDA_EXTERNAL_TASK_CLIENT", (String)"org.camunda.bpm.client", (String)"03");

    protected ExternalTaskClientException baseUrlNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("001", "Base URL cannot be null or an empty string", new Object[0]));
    }

    protected ExternalTaskClientException cannotGetHostnameException() {
        return new ExternalTaskClientException(this.exceptionMessage("002", "Cannot get hostname", new Object[0]));
    }

    public ExternalTaskClientException topicNameNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("003", "Topic name cannot be null", new Object[0]));
    }

    public ExternalTaskClientException lockDurationIsNotGreaterThanZeroException() {
        return new ExternalTaskClientException(this.exceptionMessage("004", "Lock duration is not greater than 0", new Object[0]));
    }

    public ExternalTaskClientException externalTaskHandlerNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("005", "External task handler cannot be null", new Object[0]));
    }

    public ExternalTaskClientException topicNameAlreadySubscribedException() {
        return new ExternalTaskClientException(this.exceptionMessage("006", "Topic name has already been subscribed", new Object[0]));
    }

    public ExternalTaskClientException externalTaskServiceException(String actionName, EngineClientException e) {
        Throwable causedException = e.getCause();
        if (causedException instanceof HttpResponseException) {
            switch (((HttpResponseException)causedException).getStatusCode()) {
                case 400: {
                    return new NotAcquiredException(this.exceptionMessage("007", "Exception while {}: The task's most recent lock could not be acquired", new Object[]{actionName}));
                }
                case 404: {
                    return new NotFoundException(this.exceptionMessage("008", "Exception while {}: The task could not be found", new Object[]{actionName}));
                }
                case 500: {
                    return new NotResumedException(this.exceptionMessage("009", "Exception while {}: The corresponding process instance could not be resumed", new Object[]{actionName}));
                }
            }
        }
        if (causedException instanceof ClientProtocolException || causedException instanceof IOException) {
            return new ConnectionLostException(this.exceptionMessage("010", "Exception while {}: Connection could not be established", new Object[]{actionName}));
        }
        return new ExternalTaskClientException(this.exceptionMessage("011", "Exception while {}: '{}'", new Object[]{actionName}));
    }

    public ExternalTaskClientException basicAuthCredentialsNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("012", "Basic authentication credentials (username, password) cannot be null", new Object[0]));
    }

    protected ExternalTaskClientException interceptorNullException() {
        return new ExternalTaskClientException(this.exceptionMessage("013", "Interceptor cannot be null", new Object[0]));
    }

    public UnsupportedTypeException unsupportedTypeException(Object variableValue) {
        return new UnsupportedTypeException(this.exceptionMessage("014", "Exception while converting variable value '{}' to typed variable value: no suitable mapper found for type {}", new Object[]{variableValue, variableValue.getClass().getSimpleName()}));
    }

    public UnsupportedTypeException unsupportedSerializationDataFormat(Object variableValue) {
        return new UnsupportedTypeException(this.exceptionMessage("015", "Exception while converting variable value '{}' to typed variable value: serialization data format not supported", new Object[]{variableValue, variableValue.getClass().getSimpleName()}));
    }
}

