/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.variable.mapper.ValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.BooleanValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.BytesValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.DateValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.DoubleValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.IntegerValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.LongValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.NullValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.PrimitiveValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.ShortValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.primitive.StringValueMapper;
import org.camunda.bpm.client.impl.variable.mapper.serializable.ObjectValueMapper;
import org.camunda.bpm.client.task.impl.dto.TypedValueDto;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableMappers {
    protected static final EngineClientLogger INTERNAL_LOG = ExternalTaskClientLogger.ENGINE_CLIENT_LOGGER;
    protected static final ExternalTaskClientLogger USER_LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected Map<String, ValueMapper<?>> mappers = new HashMap();

    public VariableMappers(ObjectMapper objectMapper) {
        this.registerMapper(new NullValueMapper());
        this.registerMapper(new BooleanValueMapper());
        this.registerMapper(new StringValueMapper());
        this.registerMapper(new DateValueMapper());
        this.registerMapper(new BytesValueMapper());
        this.registerMapper(new ShortValueMapper());
        this.registerMapper(new IntegerValueMapper());
        this.registerMapper(new LongValueMapper());
        this.registerMapper(new DoubleValueMapper());
        this.registerMapper(new ObjectValueMapper(objectMapper));
    }

    public VariableMap deserializeVariables(Map<String, TypedValueDto> typedValueDtoMap) throws EngineClientException {
        VariableMapImpl variableMap = new VariableMapImpl();
        for (Map.Entry<String, TypedValueDto> entry : typedValueDtoMap.entrySet()) {
            String variableName = entry.getKey();
            TypedValueDto typedValueDto = entry.getValue();
            String variableType = this.decapitalize(typedValueDto.getType());
            ValueMapper<?> mapper = this.mappers.get(variableType);
            if (mapper == null) {
                throw INTERNAL_LOG.exceptionWhileDeserializingVariables(variableName, variableType);
            }
            Object typedValue = mapper.deserializeTypedValue(typedValueDto);
            if (typedValue == null) {
                throw INTERNAL_LOG.exceptionWhileDeserializingVariablesWrongType(variableName, variableType);
            }
            variableMap.put((Object)variableName, typedValue);
        }
        return variableMap;
    }

    public <T extends TypedValue> T convertToTypedValue(Object value) {
        UntypedValueImpl untypedValue = new UntypedValueImpl(value);
        PrimitiveValueMapper<?> mapper = this.getMapperByValue((TypedValue)untypedValue);
        if (mapper == null) {
            throw USER_LOG.unsupportedTypeException(value);
        }
        return (T)mapper.convertToTypedValue(untypedValue);
    }

    public ObjectValue convertToObjectValue(ObjectValue objectValue) {
        ObjectValueMapper mapper = (ObjectValueMapper)this.mappers.get("object");
        return mapper.convertToObjectValue(objectValue);
    }

    public Map<String, TypedValueDto> serializeVariables(VariableMap variableMap) {
        HashMap<String, TypedValueDto> typedValueDtoMap = new HashMap<String, TypedValueDto>();
        variableMap.keySet().forEach(variableName -> {
            TypedValue typedValue = variableMap.getValueTyped(variableName);
            ValueMapper<?> mapper = this.mappers.get(typedValue.getType().getName());
            TypedValueDto typedValueDto = mapper.serializeTypedValue(typedValue);
            typedValueDtoMap.put((String)variableName, typedValueDto);
        });
        return typedValueDtoMap;
    }

    protected PrimitiveValueMapper<?> getMapperByValue(TypedValue value) {
        return this.mappers.values().stream().filter(mapper -> mapper instanceof PrimitiveValueMapper).filter(mapper -> ((PrimitiveValueMapper)mapper).isAssignable(value)).findFirst().orElse(null);
    }

    protected void registerMapper(ValueMapper<?> valueMapper) {
        this.mappers.put(valueMapper.getTypeName(), valueMapper);
    }

    protected String decapitalize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

