/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl.variable.mapper.primitive;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.client.impl.variable.mapper.primitive.PrimitiveValueMapper;
import org.camunda.bpm.client.task.impl.dto.TypedValueDto;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.DateValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DateValueMapper
extends PrimitiveValueMapper<DateValue> {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public DateValueMapper() {
        super(ValueType.DATE);
    }

    @Override
    public DateValue deserializeTypedValue(TypedValueDto typedValueDto) {
        Object value = typedValueDto.getValue();
        Date date = null;
        try {
            date = this.sdf.parse((String)value);
        }
        catch (ParseException e) {
            return null;
        }
        typedValueDto.setValue(date);
        return (DateValue)super.deserializeTypedValue(typedValueDto);
    }

    @Override
    public TypedValueDto serializeTypedValue(TypedValue typedValue) {
        TypedValueDto typedValueDto = super.serializeTypedValue(typedValue);
        Date date = (Date)typedValue.getValue();
        typedValueDto.setValue(this.sdf.format(date));
        return typedValueDto;
    }
}

