/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.task.impl;

import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.client.task.impl.ExternalTaskImpl;
import org.camunda.bpm.engine.variable.VariableMap;

public class ExternalTaskServiceImpl
implements ExternalTaskService {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String taskId;
    protected EngineClient engineClient;

    public ExternalTaskServiceImpl(String taskId, EngineClient engineClient) {
        this.taskId = taskId;
        this.engineClient = engineClient;
    }

    @Override
    public void unlock(ExternalTask externalTask) {
        try {
            this.engineClient.unlock(externalTask.getId());
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("unlocking the external task", e);
        }
    }

    @Override
    public void complete(ExternalTask externalTask) {
        try {
            VariableMap writtenVariableMap = ((ExternalTaskImpl)externalTask).getWrittenVariableMap();
            this.engineClient.complete(externalTask.getId(), writtenVariableMap);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("completing the external task", e);
        }
    }

    @Override
    public void handleFailure(ExternalTask externalTask, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        try {
            this.engineClient.failure(externalTask.getId(), errorMessage, errorDetails, retries, retryTimeout);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("notifying a failure", e);
        }
    }

    @Override
    public void handleBpmnError(ExternalTask externalTask, String errorCode) {
        try {
            this.engineClient.bpmnError(externalTask.getId(), errorCode);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("notifying a BPMN error", e);
        }
    }

    @Override
    public void extendLock(ExternalTask externalTask, long newDuration) {
        try {
            this.engineClient.extendLock(externalTask.getId(), newDuration);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("extending lock", e);
        }
    }
}

