/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.topic.TopicSubscription;
import org.camunda.bpm.client.topic.TopicSubscriptionBuilder;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionImpl;
import org.camunda.bpm.client.topic.impl.TopicSubscriptionManager;

public class TopicSubscriptionBuilderImpl
implements TopicSubscriptionBuilder {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected String topicName;
    protected Long lockDuration;
    protected List<String> variableNames;
    protected String businessKey;
    protected String processDefinitionId;
    protected List<String> processDefinitionIds;
    protected String processDefinitionKey;
    protected List<String> processDefinitionKeys;
    protected boolean withoutTenantId;
    protected List<String> tenantIds;
    protected ExternalTaskHandler externalTaskHandler;
    protected TopicSubscriptionManager topicSubscriptionManager;

    public TopicSubscriptionBuilderImpl(String topicName, TopicSubscriptionManager topicSubscriptionManager) {
        this.topicName = topicName;
        this.variableNames = null;
        this.lockDuration = null;
        this.topicSubscriptionManager = topicSubscriptionManager;
    }

    @Override
    public TopicSubscriptionBuilder lockDuration(long lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder handler(ExternalTaskHandler externalTaskHandler) {
        this.externalTaskHandler = externalTaskHandler;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder variables(String ... variableNames) {
        this.ensureNotNull(variableNames, "variableNames");
        this.variableNames = Arrays.asList(variableNames);
        return this;
    }

    @Override
    public TopicSubscriptionBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder processDefinitionIdIn(String ... processDefinitionIds) {
        this.ensureNotNull(processDefinitionIds, "processDefinitionIds");
        this.processDefinitionIds = Arrays.asList(processDefinitionIds);
        return this;
    }

    @Override
    public TopicSubscriptionBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder processDefinitionKeyIn(String ... processDefinitionKeys) {
        this.ensureNotNull(processDefinitionKeys, "processDefinitionKeys");
        this.processDefinitionKeys = Arrays.asList(processDefinitionKeys);
        return this;
    }

    @Override
    public TopicSubscriptionBuilder withoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public TopicSubscriptionBuilder tenantIdIn(String ... tenantIds) {
        this.ensureNotNull(tenantIds, "tenantIds");
        this.tenantIds = Arrays.asList(tenantIds);
        return this;
    }

    @Override
    public TopicSubscription open() {
        if (this.topicName == null) {
            throw LOG.topicNameNullException();
        }
        if (this.lockDuration != null && this.lockDuration <= 0L) {
            throw LOG.lockDurationIsNotGreaterThanZeroException(this.lockDuration);
        }
        if (this.externalTaskHandler == null) {
            throw LOG.externalTaskHandlerNullException();
        }
        TopicSubscriptionImpl subscription = new TopicSubscriptionImpl(this.topicName, this.lockDuration, this.externalTaskHandler, this.topicSubscriptionManager, this.variableNames, this.businessKey);
        if (this.processDefinitionId != null) {
            subscription.setProcessDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionIds != null) {
            subscription.setProcessDefinitionIdIn(this.processDefinitionIds);
        }
        if (this.processDefinitionKey != null) {
            subscription.setProcessDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeys != null) {
            subscription.setProcessDefinitionKeyIn(this.processDefinitionKeys);
        }
        if (this.withoutTenantId) {
            subscription.setWithoutTenantId(this.withoutTenantId);
        }
        if (this.tenantIds != null) {
            subscription.setTenantIdIn(this.tenantIds);
        }
        this.topicSubscriptionManager.subscribe(subscription);
        return subscription;
    }

    protected void ensureNotNull(Object tenantIds, String parameterName) {
        if (tenantIds == null) {
            throw LOG.passNullValueParameter(parameterName);
        }
    }
}

