/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.variable.impl.value;

import java.io.InputStream;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.variable.value.DeferredFileValue;
import org.camunda.bpm.engine.variable.impl.value.FileValueImpl;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;

public class DeferredFileValueImpl
extends FileValueImpl
implements DeferredFileValue {
    private static final long serialVersionUID = 1L;
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected boolean isLoaded = false;
    protected String variableName;
    protected String processInstanceId;
    protected EngineClient engineClient;

    public DeferredFileValueImpl(String filename, EngineClient engineClient) {
        super(PrimitiveValueType.FILE, filename);
        this.engineClient = engineClient;
    }

    protected void load() {
        try {
            byte[] bytes = this.engineClient.getLocalBinaryVariable(this.variableName, this.processInstanceId);
            this.setValue(bytes);
            this.isLoaded = true;
        }
        catch (EngineClientException e) {
            throw LOG.cannotLoadDeferedFileValueException(this.variableName, e);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public InputStream getValue() {
        if (!this.isLoaded()) {
            this.load();
        }
        return super.getValue();
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String toString() {
        return "DeferredFileValueImpl [mimeType=" + this.mimeType + ", filename=" + this.filename + ", type=" + this.type + ", isTransient=" + this.isTransient + ", isLoaded=" + this.isLoaded + "]";
    }
}

