/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.variable.impl.format.serializable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.spi.DataFormat;
import org.camunda.bpm.client.variable.impl.format.serializable.SerializableLogger;
import org.camunda.commons.utils.IoUtil;

public class SerializableDataFormat
implements DataFormat {
    private static final SerializableLogger LOG = ExternalTaskClientLogger.SERIALIZABLE_FORMAT_LOGGER;
    protected String name;

    public SerializableDataFormat(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canMap(Object value) {
        return value instanceof Serializable;
    }

    @Override
    public String writeValue(Object value) {
        String string;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream ois = null;
        try {
            baos = new ByteArrayOutputStream();
            ois = new ObjectOutputStream(baos);
            ois.writeObject(value);
            byte[] deserializedObjectByteArray = baos.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            string = encoder.encodeToString(deserializedObjectByteArray);
        }
        catch (IOException e) {
            try {
                throw LOG.unableToWriteValue(value, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(ois);
                IoUtil.closeSilently((Closeable)baos);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)ois);
        IoUtil.closeSilently((Closeable)baos);
        return string;
    }

    @Override
    public <T> T readValue(String value, String typeIdentifier) {
        return this.readValue(value);
    }

    @Override
    public <T> T readValue(String value, Class<T> cls) {
        return this.readValue(value);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T readValue(String value) {
        Object object;
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] base64DecodedSerializedValue = decoder.decode(value);
        ByteArrayInputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = new ByteArrayInputStream(base64DecodedSerializedValue);
            ois = new ObjectInputStream(is);
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw LOG.classNotFound(e);
                catch (IOException e2) {
                    throw LOG.unableToReadValue(value, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(ois);
                IoUtil.closeSilently((Closeable)is);
                throw throwable;
            }
        }
        IoUtil.closeSilently((Closeable)ois);
        IoUtil.closeSilently((Closeable)is);
        return (T)object;
    }

    @Override
    public String getCanonicalTypeName(Object value) {
        return value.getClass().getName();
    }
}

