/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.variable.impl.mapper;

import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.utils.Base64;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.variable.impl.AbstractTypedValueMapper;
import org.camunda.bpm.client.variable.impl.TypedValueField;
import org.camunda.bpm.client.variable.impl.value.DeferredFileValueImpl;
import org.camunda.bpm.client.variable.value.DeferredFileValue;
import org.camunda.bpm.engine.variable.impl.value.FileValueImpl;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class FileValueMapper
extends AbstractTypedValueMapper<FileValue> {
    protected EngineClient engineClient;

    public FileValueMapper(EngineClient engineClient) {
        super((ValueType)ValueType.FILE);
        this.engineClient = engineClient;
    }

    @Override
    public FileValue convertToTypedValue(UntypedValueImpl untypedValue) {
        throw new UnsupportedOperationException("Currently no automatic conversation from UntypedValue to FileValue");
    }

    @Override
    public FileValue readValue(TypedValueField value, boolean deserializeValue) {
        String encoding;
        Map<String, Object> valueInfo = value.getValueInfo();
        String filename = (String)valueInfo.get("filename");
        DeferredFileValueImpl fileValue = new DeferredFileValueImpl(filename, this.engineClient);
        String mimeType = (String)valueInfo.get("mimeType");
        if (mimeType != null) {
            fileValue.setMimeType(mimeType);
        }
        if ((encoding = (String)valueInfo.get("encoding")) != null) {
            fileValue.setEncoding(encoding);
        }
        return fileValue;
    }

    @Override
    public void writeValue(FileValue fileValue, TypedValueField typedValueField) {
        HashMap<String, Object> valueInfo = new HashMap<String, Object>();
        valueInfo.put("filename", fileValue.getFilename());
        if (fileValue.getEncoding() != null) {
            valueInfo.put("encoding", fileValue.getEncoding());
        }
        if (fileValue.getMimeType() != null) {
            valueInfo.put("mimeType", fileValue.getMimeType());
        }
        typedValueField.setValueInfo(valueInfo);
        byte[] bytes = ((FileValueImpl)fileValue).getByteArray();
        if (bytes != null) {
            typedValueField.setValue(Base64.encodeBase64String((byte[])bytes));
        }
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        if (typedValue == null || typedValue.getType() == null) {
            return false;
        }
        return typedValue.getType().getName().equals(this.valueType.getName()) && !this.isDeferred(typedValue);
    }

    @Override
    protected boolean canReadValue(TypedValueField typedValueField) {
        Object value = typedValueField.getValue();
        return value == null || value instanceof String;
    }

    protected boolean isDeferred(Object variableValue) {
        return variableValue instanceof DeferredFileValue && !((DeferredFileValue)variableValue).isLoaded();
    }
}

