/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.plugin.acm;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.camunda.bpm.cockpit.plugin.acm.DetailedCaseExecution;
import org.camunda.bpm.cockpit.plugin.resource.AbstractCockpitPluginResource;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.PlanItemImpl;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class CaseExecutionDetailedResource
extends AbstractCockpitPluginResource {
    private static final String DEFINITION_REF = "definitionRef";
    private final String id;

    public CaseExecutionDetailedResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Produces(value={"application/json"})
    public List<DetailedCaseExecution> findTasks() {
        List executions = this.getProcessEngine().getCaseService().createCaseExecutionQuery().caseInstanceId(this.id).list();
        List<DetailedCaseExecution> detailedExecutions = DetailedCaseExecution.fromExecutions(executions);
        if (!detailedExecutions.isEmpty()) {
            String caseDefinition = detailedExecutions.get(0).getCaseDefinitionId();
            InputStream caseModel = this.getProcessEngine().getRepositoryService().getCaseModel(caseDefinition);
            CmmnModelInstance modelInstance = Cmmn.readModelFromStream((InputStream)caseModel);
            for (DetailedCaseExecution detailed : detailedExecutions) {
                ModelElementInstance plainItemModel = modelInstance.getModelElementById(detailed.getActivityId());
                if (!(plainItemModel instanceof PlanItemImpl)) continue;
                PlanItemImpl planItem = (PlanItemImpl)plainItemModel;
                String attributeValue = planItem.getAttributeValue(DEFINITION_REF);
                ModelElementInstance element = modelInstance.getModelElementById(attributeValue);
                detailed.enrichType(element);
                detailed.enrichLabels(element);
            }
        }
        return detailedExecutions;
    }
}

