/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.plugin.acm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.model.cmmn.impl.instance.CaseImpl;
import org.camunda.bpm.model.cmmn.impl.instance.CaseTaskImpl;
import org.camunda.bpm.model.cmmn.impl.instance.EventListenerImpl;
import org.camunda.bpm.model.cmmn.impl.instance.HumanTaskImpl;
import org.camunda.bpm.model.cmmn.impl.instance.MilestoneImpl;
import org.camunda.bpm.model.cmmn.impl.instance.PlanItemDefinitionImpl;
import org.camunda.bpm.model.cmmn.impl.instance.ProcessTaskImpl;
import org.camunda.bpm.model.cmmn.impl.instance.StageImpl;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

@XmlRootElement
public class DetailedCaseExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String activityId;
    private String caseDefinitionId;
    private String caseInstanceId;
    private boolean enabled;
    private boolean disabled;
    private boolean active;
    private Type type;
    private String name;
    private String description;

    public static DetailedCaseExecution fromExecutionEntity(CaseExecutionEntity executionEntity, CaseExecution execution) {
        return new DetailedCaseExecution(executionEntity.getId(), executionEntity.getActivityId(), executionEntity.getCaseDefinitionId(), executionEntity.getCaseInstanceId(), execution.isEnabled(), execution.isActive(), execution.isDisabled());
    }

    public static List<DetailedCaseExecution> fromExecutions(List<CaseExecution> executions) {
        ArrayList<DetailedCaseExecution> tasks = new ArrayList<DetailedCaseExecution>();
        for (CaseExecution ce : executions) {
            CaseExecutionEntity cee;
            if (!(ce instanceof CaseExecutionEntity) || (cee = (CaseExecutionEntity)ce).isCaseInstanceExecution()) continue;
            tasks.add(DetailedCaseExecution.fromExecutionEntity(cee, ce));
        }
        return tasks;
    }

    public DetailedCaseExecution(String id, String activity, String caseDefinitionId, String caseInstanceId, boolean enabled, boolean active, boolean disabled) {
        this.id = id;
        this.activityId = activity;
        this.caseDefinitionId = caseDefinitionId;
        this.caseInstanceId = caseInstanceId;
        this.enabled = enabled;
        this.active = active;
        this.disabled = disabled;
    }

    public DetailedCaseExecution() {
    }

    public void enrichType(ModelElementInstance element) {
        if (element instanceof HumanTaskImpl) {
            this.setType(Type.HUMANTASK);
        } else if (element instanceof CaseTaskImpl) {
            this.setType(Type.CASETASK);
        } else if (element instanceof CaseImpl) {
            this.setType(Type.CASE);
        } else if (element instanceof StageImpl) {
            this.setType(Type.STAGE);
        } else if (element instanceof ProcessTaskImpl) {
            this.setType(Type.PROCESSTASK);
        } else if (element instanceof MilestoneImpl) {
            this.setType(Type.MILESTONE);
        } else if (element instanceof EventListenerImpl) {
            this.setType(Type.EVENTLISTENER);
        } else {
            throw new IllegalStateException("Unknown model element of type " + element.getClass().getName() + " detected.");
        }
    }

    public void enrichLabels(ModelElementInstance element) {
        if (element instanceof PlanItemDefinitionImpl) {
            PlanItemDefinitionImpl pid = (PlanItemDefinitionImpl)element;
            this.setName(pid.getName());
            this.setDescription(pid.getDescription());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public static enum Type {
        HUMANTASK,
        CASETASK,
        PROCESSTASK,
        STAGE,
        CASE,
        MILESTONE,
        EVENTLISTENER;

    }
}

