/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.CommitInfo;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.BlameCallback2;
import org.tigris.subversion.javahl.BlameCallback3;
import org.tigris.subversion.javahl.BlameCallbackImpl;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.ChangelistCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.ConflictResolverCallback;
import org.tigris.subversion.javahl.CopySource;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.DiffSummary;
import org.tigris.subversion.javahl.DiffSummaryReceiver;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.InfoCallback;
import org.tigris.subversion.javahl.ListCallback;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogDate;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.LogMessageCallback;
import org.tigris.subversion.javahl.Mergeinfo;
import org.tigris.subversion.javahl.Notify;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.Path;
import org.tigris.subversion.javahl.ProgressEvent;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.PromptUserPassword2;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.ProplistCallback;
import org.tigris.subversion.javahl.ProplistCallbackImpl;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientLogLevel;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.Version;

public class SVNClient
implements SVNClientInterface {
    private org.apache.subversion.javahl.SVNClient aSVNClient = new org.apache.subversion.javahl.SVNClient();
    protected long cppAddr = -559038737L;
    private CommitMessageCallback cachedHandler = null;

    public void dispose() {
        this.aSVNClient.dispose();
    }

    protected void finalize() {
    }

    public Version getVersion() {
        return new Version(NativeResources.getVersion());
    }

    public String getAdminDirectoryName() {
        return this.aSVNClient.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String name) {
        return this.aSVNClient.isAdminDirectory(name);
    }

    public String getLastPath() {
        return this.aSVNClient.getLastPath();
    }

    public Status singleStatus(String path, boolean onServer) throws ClientException {
        Status[] statusArray = this.status(path, false, onServer, true, false, false);
        if (statusArray == null || statusArray.length == 0) {
            return null;
        }
        return statusArray[0];
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll) throws ClientException {
        return this.status(path, descend, onServer, getAll, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore) throws ClientException {
        return this.status(path, descend, onServer, getAll, noIgnore, false);
    }

    public Status[] status(String path, boolean descend, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals) throws ClientException {
        final ArrayList statuses = new ArrayList();
        this.status(path, Depth.unknownOrImmediates(descend), onServer, getAll, noIgnore, ignoreExternals, null, new StatusCallback(){

            public void doStatus(Status status) {
                statuses.add(status);
            }
        });
        return statuses.toArray(new Status[statuses.size()]);
    }

    public void status(String path, int depth, boolean onServer, boolean getAll, boolean noIgnore, boolean ignoreExternals, String[] changelists, final StatusCallback callback) throws ClientException {
        try {
            this.aSVNClient.status(path, Depth.toADepth(depth), onServer, getAll, noIgnore, ignoreExternals, changelists == null ? null : Arrays.asList(changelists), new org.apache.subversion.javahl.callback.StatusCallback(){

                public void doStatus(String path, org.apache.subversion.javahl.types.Status aStatus) {
                    if (aStatus != null) {
                        callback.doStatus(new Status(SVNClient.this.aSVNClient, aStatus));
                    } else {
                        callback.doStatus(new Status(path));
                    }
                }
            });
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public DirEntry[] list(String url, Revision revision, boolean recurse) throws ClientException {
        return this.list(url, revision, revision, recurse);
    }

    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        class MyListCallback
        implements ListCallback {
            private List<DirEntry> dirents = new ArrayList<DirEntry>();

            MyListCallback() {
            }

            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == 1) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                this.dirents.add(dirent);
            }

            public DirEntry[] getDirEntryArray() {
                return this.dirents.toArray(new DirEntry[this.dirents.size()]);
            }
        }
        MyListCallback callback = new MyListCallback();
        this.list(url, revision, pegRevision, Depth.infinityOrImmediates(recurse), -1, false, callback);
        return callback.getDirEntryArray();
    }

    public void list(String url, Revision revision, Revision pegRevision, int depth, int direntFields, boolean fetchLocks, final ListCallback callback) throws ClientException {
        try {
            this.aSVNClient.list(url, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), Depth.toADepth(depth), direntFields, fetchLocks, new org.apache.subversion.javahl.callback.ListCallback(){

                public void doEntry(org.apache.subversion.javahl.types.DirEntry dirent, org.apache.subversion.javahl.types.Lock lock) {
                    callback.doEntry(new DirEntry(dirent), lock == null ? null : new Lock(lock));
                }
            });
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void username(String username) {
        this.aSVNClient.username(username);
    }

    public void password(String password) {
        this.aSVNClient.password(password);
    }

    public void setPrompt(PromptUserPassword prompt) {
        this.aSVNClient.setPrompt(new PromptUser1Wrapper(prompt));
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, true, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, false);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath) throws ClientException {
        return this.logMessages(path, revisionStart, revisionEnd, stopOnCopy, discoverPath, 0L);
    }

    public LogMessage[] logMessages(String path, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, long limit) throws ClientException {
        class MyLogMessageCallback
        implements LogMessageCallback {
            private List<LogMessage> messages = new ArrayList<LogMessage>();

            MyLogMessageCallback() {
            }

            public void singleMessage(ChangePath[] changedPaths, long revision, Map revprops, boolean hasChildren) {
                long timeMicros;
                String author = (String)revprops.get("svn:author");
                String message = (String)revprops.get("svn:log");
                try {
                    LogDate date = new LogDate((String)revprops.get("svn:date"));
                    timeMicros = date.getTimeMicros();
                }
                catch (ParseException ex) {
                    timeMicros = 0L;
                }
                LogMessage msg = new LogMessage(changedPaths, revision, author, timeMicros, message);
                if (revision != -1L) {
                    this.messages.add(msg);
                }
            }

            public LogMessage[] getMessages() {
                return this.messages.toArray(new LogMessage[this.messages.size()]);
            }
        }
        MyLogMessageCallback callback = new MyLogMessageCallback();
        String[] revProps = new String[]{"svn:log", "svn:date", "svn:author"};
        this.logMessages(path, revisionEnd, revisionStart, revisionEnd, stopOnCopy, discoverPath, false, revProps, limit, callback);
        return callback.getMessages();
    }

    public void logMessages(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, String[] revProps, long limit, LogMessageCallback callback) throws ClientException {
        this.logMessages(path, pegRevision, this.toRevisionRange(revisionStart, revisionEnd), stopOnCopy, discoverPath, includeMergedRevisions, revProps, limit, callback);
    }

    public void logMessages(String path, Revision pegRevision, RevisionRange[] revisionRanges, boolean stopOnCopy, boolean discoverPath, boolean includeMergedRevisions, String[] revProps, long limit, LogMessageCallback callback) throws ClientException {
        try {
            ArrayList<org.apache.subversion.javahl.types.RevisionRange> aRevisions = new ArrayList<org.apache.subversion.javahl.types.RevisionRange>(revisionRanges.length);
            for (RevisionRange range : revisionRanges) {
                aRevisions.add(range.toApache());
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ALogMessageCallback
            implements org.apache.subversion.javahl.callback.LogMessageCallback {
                private LogMessageCallback callback;

                public ALogMessageCallback(LogMessageCallback callback) {
                    this.callback = callback;
                }

                @Override
                public void singleMessage(Set<org.apache.subversion.javahl.types.ChangePath> aChangedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
                    Object[] changedPaths;
                    HashMap<String, String> oldRevprops = new HashMap<String, String>();
                    if (aChangedPaths != null) {
                        changedPaths = new ChangePath[aChangedPaths.size()];
                        int i = 0;
                        for (org.apache.subversion.javahl.types.ChangePath cp : aChangedPaths) {
                            changedPaths[i] = new ChangePath(cp);
                            ++i;
                        }
                        Arrays.sort(changedPaths);
                    } else {
                        changedPaths = null;
                    }
                    for (String key : revprops.keySet()) {
                        oldRevprops.put(key, new String(revprops.get(key)));
                    }
                    this.callback.singleMessage((ChangePath[])changedPaths, revision, oldRevprops, hasChildren);
                }
            }
            this.aSVNClient.logMessages(path, pegRevision == null ? null : pegRevision.toApache(), aRevisions, stopOnCopy, discoverPath, includeMergedRevisions, revProps == null ? null : new HashSet<String>(Arrays.asList(revProps)), limit, new ALogMessageCallback(callback));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public long checkout(String moduleName, String destPath, Revision revision, boolean recurse) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, recurse, false);
    }

    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.checkout(moduleName, destPath, revision, revision, Depth.infinityOrFiles(recurse), ignoreExternals, false);
    }

    public long checkout(String moduleName, String destPath, Revision revision, Revision pegRevision, int depth, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        try {
            return this.aSVNClient.checkout(moduleName, destPath, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), Depth.toADepth(depth), ignoreExternals, allowUnverObstructions);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void notification(final Notify notify) {
        this.notification2(new Notify2(){

            public void onNotify(NotifyInformation info) {
                notify.onNotify(info.getPath(), info.getAction(), info.getKind(), info.getMimeType(), info.getContentState(), info.getPropState(), info.getRevision());
            }
        });
    }

    public void notification2(final Notify2 notify) {
        this.aSVNClient.notification2(new ClientNotifyCallback(){

            public void onNotify(ClientNotifyInformation aInfo) {
                notify.onNotify(new NotifyInformation(aInfo));
            }
        });
    }

    public void setConflictResolver(final ConflictResolverCallback listener) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyConflictResolverCallback
        implements org.apache.subversion.javahl.callback.ConflictResolverCallback {
            MyConflictResolverCallback() {
            }

            @Override
            public ConflictResult resolve(org.apache.subversion.javahl.ConflictDescriptor aDescrip) throws org.apache.subversion.javahl.SubversionException {
                try {
                    return listener.resolve(new ConflictDescriptor(aDescrip)).toApache();
                }
                catch (SubversionException ex) {
                    throw org.apache.subversion.javahl.ClientException.fromException(ex);
                }
            }
        }
        this.aSVNClient.setConflictResolver(new MyConflictResolverCallback());
    }

    public void setProgressListener(final ProgressListener listener) {
        this.aSVNClient.setProgressCallback(new ProgressCallback(){

            public void onProgress(org.apache.subversion.javahl.ProgressEvent event) {
                listener.onProgress(new ProgressEvent(event));
            }
        });
    }

    public void commitMessageHandler(CommitMessage messageHandler) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyCommitMessageHandler
        implements CommitMessageCallback {
            private CommitMessage messageHandler;

            public MyCommitMessageHandler(CommitMessage messageHandler) {
                this.messageHandler = messageHandler;
            }

            @Override
            public String getLogMessage(Set<org.apache.subversion.javahl.CommitItem> elementsToBeCommited) {
                CommitItem[] aElements = new CommitItem[elementsToBeCommited.size()];
                int i = 0;
                for (org.apache.subversion.javahl.CommitItem item : elementsToBeCommited) {
                    aElements[i] = new CommitItem(item);
                    ++i;
                }
                if (this.messageHandler == null) {
                    return "";
                }
                return this.messageHandler.getLogMessage(aElements);
            }
        }
        this.cachedHandler = new MyCommitMessageHandler(messageHandler);
    }

    public void remove(String[] path, String message, boolean force) throws ClientException {
        this.remove(path, message, force, false, null);
    }

    public void remove(String[] paths, String message, boolean force, boolean keepLocal, Map revpropTable) throws ClientException {
        try {
            this.aSVNClient.remove(new HashSet<String>(Arrays.asList(paths)), force, keepLocal, revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void revert(String path, boolean recurse) throws ClientException {
        this.revert(path, Depth.infinityOrEmpty(recurse), null);
    }

    public void revert(String path, int depth, String[] changelists) throws ClientException {
        try {
            this.aSVNClient.revert(path, Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void add(String path, boolean recurse) throws ClientException {
        this.add(path, recurse, false);
    }

    public void add(String path, boolean recurse, boolean force) throws ClientException {
        this.add(path, Depth.infinityOrEmpty(recurse), force, false, false);
    }

    public void add(String path, int depth, boolean force, boolean noIgnores, boolean addParents) throws ClientException {
        try {
            this.aSVNClient.add(path, Depth.toADepth(depth), force, noIgnores, addParents);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public long update(String path, Revision revision, boolean recurse) throws ClientException {
        return this.update(new String[]{path}, revision, recurse, false)[0];
    }

    public long[] update(String[] path, Revision revision, boolean recurse, boolean ignoreExternals) throws ClientException {
        return this.update(path, revision, Depth.unknownOrFiles(recurse), false, ignoreExternals, false);
    }

    public long update(String path, Revision revision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        return this.update(new String[]{path}, revision, depth, depthIsSticky, ignoreExternals, allowUnverObstructions)[0];
    }

    public long[] update(String[] paths, Revision revision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        try {
            return this.aSVNClient.update(new HashSet<String>(Arrays.asList(paths)), revision == null ? null : revision.toApache(), Depth.toADepth(depth), depthIsSticky, false, ignoreExternals, allowUnverObstructions);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public long commit(String[] path, String message, boolean recurse) throws ClientException {
        return this.commit(path, message, recurse, false);
    }

    public long commit(String[] path, String message, boolean recurse, boolean noUnlock) throws ClientException {
        return this.commit(path, message, Depth.infinityOrEmpty(recurse), noUnlock, false, null, null);
    }

    public long commit(String[] paths, String message, int depth, boolean noUnlock, boolean keepChangelist, String[] changelists, Map revpropTable) throws ClientException {
        try {
            final long[] revList = new long[]{-1L};
            CommitCallback callback = new CommitCallback(){

                public void commitInfo(CommitInfo info) {
                    revList[0] = info.getRevision();
                }
            };
            this.aSVNClient.commit(new HashSet<String>(Arrays.asList(paths)), Depth.toADepth(depth), noUnlock, keepChangelist, changelists == null ? null : Arrays.asList(changelists), revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), callback);
            return revList[0];
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void copy(CopySource[] sources, String destPath, String message, boolean copyAsChild, boolean makeParents, boolean ignoreExternals, Map revpropTable) throws ClientException {
        try {
            ArrayList<org.apache.subversion.javahl.types.CopySource> aCopySources = new ArrayList<org.apache.subversion.javahl.types.CopySource>(sources.length);
            for (CopySource src : sources) {
                aCopySources.add(src.toApache());
            }
            this.aSVNClient.copy(aCopySources, destPath, copyAsChild, makeParents, ignoreExternals, revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void copy(CopySource[] sources, String destPath, String message, boolean copyAsChild, boolean makeParents, Map revpropTable) throws ClientException {
        this.copy(sources, destPath, message, copyAsChild, makeParents, false, revpropTable);
    }

    public void copy(String srcPath, String destPath, String message, Revision revision) throws ClientException {
        this.copy(new CopySource[]{new CopySource(srcPath, revision, Revision.HEAD)}, destPath, message, true, false, null);
    }

    public void move(String[] srcPaths, String destPath, String message, boolean force, boolean moveAsChild, boolean makeParents, Map revpropTable) throws ClientException {
        try {
            this.aSVNClient.move(new HashSet<String>(Arrays.asList(srcPaths)), destPath, force, moveAsChild, makeParents, revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void move(String srcPath, String destPath, String message, Revision ignored, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public void move(String srcPath, String destPath, String message, boolean force) throws ClientException {
        this.move(new String[]{srcPath}, destPath, message, force, true, false, null);
    }

    public void mkdir(String[] paths, String message, boolean makeParents, Map revpropTable) throws ClientException {
        try {
            this.aSVNClient.mkdir(new HashSet<String>(Arrays.asList(paths)), makeParents, revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void mkdir(String[] path, String message) throws ClientException {
        this.mkdir(path, message, false, null);
    }

    public void cleanup(String path) throws ClientException {
        try {
            this.aSVNClient.cleanup(path);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void resolved(String path, boolean recurse) throws ClientException {
        try {
            this.resolve(path, Depth.infinityOrEmpty(recurse), 6);
        }
        catch (SubversionException e) {
            throw ClientException.fromException(e);
        }
    }

    public void resolve(String path, int depth, int conflictResult) throws SubversionException {
        try {
            this.aSVNClient.resolve(path, Depth.toADepth(depth), ConflictResult.Choice.values()[conflictResult]);
        }
        catch (org.apache.subversion.javahl.SubversionException ex) {
            throw new SubversionException(ex);
        }
    }

    public long doExport(String srcPath, String destPath, Revision revision, boolean force) throws ClientException {
        return this.doExport(srcPath, destPath, revision, revision, force, false, true, null);
    }

    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL) throws ClientException {
        return this.doExport(srcPath, destPath, revision, pegRevision, force, ignoreExternals, Depth.infinityOrFiles(recurse), nativeEOL);
    }

    public long doExport(String srcPath, String destPath, Revision revision, Revision pegRevision, boolean force, boolean ignoreExternals, int depth, String nativeEOL) throws ClientException {
        try {
            return this.aSVNClient.doExport(srcPath, destPath, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), force, ignoreExternals, Depth.toADepth(depth), nativeEOL);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public long doSwitch(String path, String url, Revision revision, boolean recurse) throws ClientException {
        return this.doSwitch(path, url, revision, Revision.HEAD, Depth.unknownOrFiles(recurse), false, false, false);
    }

    public long doSwitch(String path, String url, Revision revision, Revision pegRevision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions) throws ClientException {
        return this.doSwitch(path, url, revision, pegRevision, depth, depthIsSticky, ignoreExternals, allowUnverObstructions, true);
    }

    public long doSwitch(String path, String url, Revision revision, Revision pegRevision, int depth, boolean depthIsSticky, boolean ignoreExternals, boolean allowUnverObstructions, boolean ignoreAncestry) throws ClientException {
        try {
            return this.aSVNClient.doSwitch(path, url, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), Depth.toADepth(depth), depthIsSticky, ignoreExternals, allowUnverObstructions, ignoreAncestry);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void doImport(String path, String url, String message, boolean recurse) throws ClientException {
        this.doImport(path, url, message, Depth.infinityOrFiles(recurse), false, false, null);
    }

    public void doImport(String path, String url, String message, int depth, boolean noIgnore, boolean ignoreUnknownNodeTypes, Map revpropTable) throws ClientException {
        try {
            this.aSVNClient.doImport(path, url, Depth.toADepth(depth), noIgnore, ignoreUnknownNodeTypes, revpropTable, message == null ? this.cachedHandler : new ConstMsg(message), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public String[] suggestMergeSources(String path, Revision pegRevision) throws SubversionException {
        try {
            return this.aSVNClient.suggestMergeSources(path, pegRevision == null ? null : pegRevision.toApache()).toArray(new String[0]);
        }
        catch (org.apache.subversion.javahl.SubversionException ex) {
            throw new SubversionException(ex);
        }
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, Depth.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        try {
            this.aSVNClient.merge(path1, revision1 == null ? null : revision1.toApache(), path2, revision2 == null ? null : revision2.toApache(), localPath, force, Depth.toADepth(depth), ignoreAncestry, dryRun, recordOnly);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void merge(String path, Revision pegRevision, Revision revision1, Revision revision2, String localPath, boolean force, boolean recurse, boolean ignoreAncestry, boolean dryRun) throws ClientException {
        this.merge(path, pegRevision, this.toRevisionRange(revision1, revision2), localPath, force, Depth.infinityOrFiles(recurse), ignoreAncestry, dryRun, false);
    }

    public void merge(String path, Revision pegRevision, RevisionRange[] revisions, String localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        try {
            ArrayList<org.apache.subversion.javahl.types.RevisionRange> aRevisions = new ArrayList<org.apache.subversion.javahl.types.RevisionRange>(revisions.length);
            for (RevisionRange range : revisions) {
                aRevisions.add(range.toApache());
            }
            this.aSVNClient.merge(path, pegRevision == null ? null : pegRevision.toApache(), aRevisions, localPath, force, Depth.toADepth(depth), ignoreAncestry, dryRun, recordOnly);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void mergeReintegrate(String path, Revision pegRevision, String localPath, boolean dryRun) throws ClientException {
        try {
            this.aSVNClient.mergeReintegrate(path, pegRevision == null ? null : pegRevision.toApache(), localPath, dryRun);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public Mergeinfo getMergeinfo(String path, Revision pegRevision) throws SubversionException {
        try {
            org.apache.subversion.javahl.types.Mergeinfo aMergeinfo = this.aSVNClient.getMergeinfo(path, pegRevision == null ? null : pegRevision.toApache());
            if (aMergeinfo == null) {
                return null;
            }
            return new Mergeinfo(aMergeinfo);
        }
        catch (org.apache.subversion.javahl.SubversionException ex) {
            throw new SubversionException(ex);
        }
    }

    public void getMergeinfoLog(int kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, int depth, String[] revprops, final LogMessageCallback callback) throws ClientException {
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ALogMessageCallback
            implements org.apache.subversion.javahl.callback.LogMessageCallback {
                ALogMessageCallback() {
                }

                @Override
                public void singleMessage(Set<org.apache.subversion.javahl.types.ChangePath> aChangedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
                    ChangePath[] changedPaths;
                    if (aChangedPaths != null) {
                        changedPaths = new ChangePath[aChangedPaths.size()];
                        int i = 0;
                        for (org.apache.subversion.javahl.types.ChangePath cp : aChangedPaths) {
                            changedPaths[i] = new ChangePath(cp);
                            ++i;
                        }
                    } else {
                        changedPaths = null;
                    }
                    callback.singleMessage(changedPaths, revision, revprops, hasChildren);
                }
            }
            this.aSVNClient.getMergeinfoLog(Mergeinfo.LogKind.values()[kind], pathOrUrl, pegRevision == null ? null : pegRevision.toApache(), mergeSourceUrl, srcPegRevision == null ? null : srcPegRevision.toApache(), discoverChangedPaths, Depth.toADepth(depth), revprops == null ? null : new HashSet<String>(Arrays.asList(revprops)), new ALogMessageCallback());
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void getMergeinfoLog(int kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, String[] revprops, LogMessageCallback callback) throws ClientException {
        this.getMergeinfoLog(kind, pathOrUrl, pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths, 0, revprops, callback);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse) throws ClientException {
        this.diff(target1, revision1, target2, revision2, outFileName, recurse, true, false, false);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target1, revision1, target2, revision2, null, outFileName, Depth.unknownOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target1, revision1, target2, revision2, relativeToDir, outFileName, depth, changelists, ignoreAncestry, noDiffDeleted, force, false);
    }

    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            this.aSVNClient.diff(target1, revision1 == null ? null : revision1.toApache(), target2, revision2 == null ? null : revision2.toApache(), relativeToDir, outFileName, Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), ignoreAncestry, noDiffDeleted, force, copiesAsAdds);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, null, outFileName, Depth.unknownOrFiles(recurse), null, ignoreAncestry, noDiffDeleted, force);
    }

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, outFileName, depth, changelists, ignoreAncestry, noDiffDeleted, force, false);
    }

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, int depth, String[] changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            this.aSVNClient.diff(target, pegRevision == null ? null : pegRevision.toApache(), startRevision == null ? null : startRevision.toApache(), endRevision == null ? null : endRevision.toApache(), relativeToDir, outFileName, Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), ignoreAncestry, noDiffDeleted, force, copiesAsAdds);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void diffSummarize(String target1, Revision revision1, String target2, Revision revision2, int depth, String[] changelists, boolean ignoreAncestry, DiffSummaryReceiver receiver) throws ClientException {
        try {
            MyDiffSummaryReceiver aReceiver = new MyDiffSummaryReceiver(receiver);
            this.aSVNClient.diffSummarize(target1, revision1 == null ? null : revision1.toApache(), target2, revision2 == null ? null : revision2.toApache(), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), ignoreAncestry, (DiffSummaryCallback)aReceiver);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void diffSummarize(String target, Revision pegRevision, Revision startRevision, Revision endRevision, int depth, String[] changelists, boolean ignoreAncestry, DiffSummaryReceiver receiver) throws ClientException {
        try {
            MyDiffSummaryReceiver aReceiver = new MyDiffSummaryReceiver(receiver);
            this.aSVNClient.diffSummarize(target, pegRevision == null ? null : pegRevision.toApache(), startRevision == null ? null : startRevision.toApache(), endRevision == null ? null : endRevision.toApache(), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), ignoreAncestry, (DiffSummaryCallback)aReceiver);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public PropertyData[] properties(String path) throws ClientException {
        return this.properties(path, null);
    }

    public PropertyData[] properties(String path, Revision revision) throws ClientException {
        return this.properties(path, revision, revision);
    }

    public PropertyData[] properties(String path, Revision revision, Revision pegRevision) throws ClientException {
        ProplistCallbackImpl callback = new ProplistCallbackImpl();
        this.properties(path, revision, pegRevision, 0, null, callback);
        Map<String, String> propMap = callback.getProperties(path);
        if (propMap == null) {
            return new PropertyData[0];
        }
        PropertyData[] props = new PropertyData[propMap.size()];
        int i = 0;
        for (String key : propMap.keySet()) {
            props[i] = new PropertyData(path, key, propMap.get(key));
            ++i;
        }
        return props;
    }

    public void properties(String path, Revision revision, Revision pegRevision, int depth, String[] changelists, ProplistCallback callback) throws ClientException {
        try {
            this.aSVNClient.properties(path, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), callback);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void propertySet(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, Depth.infinityOrEmpty(recurse), null, force, null);
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertySet(path, name, value, recurse, false);
    }

    public void propertySet(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, new String(value), recurse, force);
    }

    public void propertySet(String path, String name, String value, int depth, String[] changelists, boolean force, Map revpropTable) throws ClientException {
        try {
            if (Path.isURL(path)) {
                Info2[] infos = this.info2(path, Revision.HEAD, Revision.HEAD, false);
                this.aSVNClient.propertySetRemote(path, infos[0].getRev(), name, value == null ? null : value.getBytes(), this.cachedHandler, force, revpropTable, null);
            } else {
                HashSet<String> paths = new HashSet<String>();
                paths.add(path);
                this.aSVNClient.propertySetLocal(paths, name, value == null ? null : value.getBytes(), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), force);
            }
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void propertyRemove(String path, String name, boolean recurse) throws ClientException {
        this.propertyRemove(path, name, Depth.infinityOrEmpty(recurse), null);
    }

    public void propertyRemove(String path, String name, int depth, String[] changelists) throws ClientException {
        this.propertySet(path, name, null, depth, changelists, false, null);
    }

    public void propertyCreate(String path, String name, String value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, String value, boolean recurse, boolean force) throws ClientException {
        this.propertySet(path, name, value, recurse, force);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse) throws ClientException {
        this.propertyCreate(path, name, value, recurse, false);
    }

    public void propertyCreate(String path, String name, byte[] value, boolean recurse, boolean force) throws ClientException {
        this.propertyCreate(path, name, new String(value), recurse, force);
    }

    public void propertyCreate(String path, String name, String value, int depth, String[] changelists, boolean force) throws ClientException {
        this.propertySet(path, name, value, depth, changelists, force, null);
    }

    public PropertyData revProperty(String path, String name, Revision rev) throws ClientException {
        try {
            return new PropertyData(path, name, new String(this.aSVNClient.revProperty(path, name, rev == null ? null : rev.toApache())));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public PropertyData[] revProperties(String path, Revision rev) throws ClientException {
        try {
            Map<String, byte[]> aProps = this.aSVNClient.revProperties(path, rev == null ? null : rev.toApache());
            PropertyData[] propData = new PropertyData[aProps.size()];
            int i = 0;
            for (String key : aProps.keySet()) {
                propData[i] = new PropertyData(path, key, new String(aProps.get(key)));
                ++i;
            }
            return propData;
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void setRevProperty(String path, String name, Revision rev, String value, boolean force) throws ClientException {
        this.setRevProperty(path, name, rev, value, null, force);
    }

    public void setRevProperty(String path, String name, Revision rev, String value, String originalValue, boolean force) throws ClientException {
        try {
            this.aSVNClient.setRevProperty(path, name, rev == null ? null : rev.toApache(), value, originalValue, force);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public PropertyData propertyGet(String path, String name) throws ClientException {
        return this.propertyGet(path, name, null);
    }

    public PropertyData propertyGet(String path, String name, Revision revision) throws ClientException {
        return this.propertyGet(path, name, revision, revision);
    }

    public PropertyData propertyGet(String path, String name, Revision revision, Revision pegRevision) throws ClientException {
        try {
            return new PropertyData(path, name, new String(this.aSVNClient.propertyGet(path, name, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache())));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public byte[] fileContent(String path, Revision revision) throws ClientException {
        return this.fileContent(path, revision, revision);
    }

    public byte[] fileContent(String path, Revision revision, Revision pegRevision) throws ClientException {
        try {
            return this.aSVNClient.fileContent(path, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache());
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void streamFileContent(String path, Revision revision, Revision pegRevision, int bufferSize, OutputStream stream) throws ClientException {
        try {
            this.aSVNClient.streamFileContent(path, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), stream);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void relocate(String from, String to, String path, boolean recurse) throws ClientException {
        if (!recurse) {
            throw new ClientException("relocate only support full recursion", null, -1);
        }
        try {
            this.aSVNClient.relocate(from, to, path, true);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public byte[] blame(String path, Revision revisionStart, Revision revisionEnd) throws ClientException {
        BlameCallbackImpl callback = new BlameCallbackImpl();
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < callback.numberOfLines(); ++i) {
            BlameCallbackImpl.BlameLine line = callback.getBlameLine(i);
            if (line == null) continue;
            sb.append(line.toString());
            sb.append("\n");
        }
        return sb.toString().getBytes();
    }

    public void blame(String path, Revision revisionStart, Revision revisionEnd, BlameCallback callback) throws ClientException {
        this.blame(path, revisionEnd, revisionStart, revisionEnd, callback);
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, final BlameCallback callback) throws ClientException {
        this.blame(path, pegRevision, revisionStart, revisionEnd, false, false, new BlameCallback2(){

            public void singleLine(Date date, long revision, String author, Date merged_date, long merged_revision, String merged_author, String merged_path, String line) {
                callback.singleLine(date, revision, author, line);
            }
        });
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, final BlameCallback2 callback) throws ClientException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BlameCallback2Wrapper
        implements BlameCallback3 {
            BlameCallback2Wrapper() {
            }

            @Override
            public void singleLine(long lineNum, long revision, Map revProps, long mergedRevision, Map mergedRevProps, String mergedPath, String line, boolean localChange) throws ClientException {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                try {
                    callback.singleLine(df.parse(new String((byte[])revProps.get("svn:date"))), revision, new String((byte[])revProps.get("svn:author")), mergedRevProps == null ? null : df.parse(new String((byte[])mergedRevProps.get("svn:date"))), mergedRevision, mergedRevProps == null ? null : new String((byte[])mergedRevProps.get("svn:author")), mergedPath, line);
                }
                catch (ParseException e) {
                    throw ClientException.fromException(e);
                }
            }
        }
        this.blame(path, pegRevision, revisionStart, revisionEnd, ignoreMimeType, includeMergedRevisions, new BlameCallback2Wrapper());
    }

    public void blame(String path, Revision pegRevision, Revision revisionStart, Revision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions, final BlameCallback3 callback) throws ClientException {
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyBlameCallback
            implements org.apache.subversion.javahl.callback.BlameCallback {
                MyBlameCallback() {
                }

                public void singleLine(long lineNum, long revision, Map revProps, long mergedRevision, Map mergedRevProps, String mergedPath, String line, boolean localChange) throws org.apache.subversion.javahl.ClientException {
                    try {
                        callback.singleLine(lineNum, revision, revProps, mergedRevision, mergedRevProps, mergedPath, line, localChange);
                    }
                    catch (ClientException ex) {
                        throw org.apache.subversion.javahl.ClientException.fromException(ex);
                    }
                }
            }
            this.aSVNClient.blame(path, pegRevision == null ? null : pegRevision.toApache(), revisionStart == null ? null : revisionStart.toApache(), revisionEnd == null ? null : revisionEnd.toApache(), ignoreMimeType, includeMergedRevisions, new MyBlameCallback());
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void setConfigDirectory(String configDir) throws ClientException {
        try {
            this.aSVNClient.setConfigDirectory(configDir);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public String getConfigDirectory() throws ClientException {
        try {
            return this.aSVNClient.getConfigDirectory();
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void cancelOperation() throws ClientException {
        try {
            this.aSVNClient.cancelOperation();
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public Info info(String path) throws ClientException {
        try {
            final ArrayList infos = new ArrayList();
            this.aSVNClient.info2(path, org.apache.subversion.javahl.types.Revision.HEAD, org.apache.subversion.javahl.types.Revision.HEAD, org.apache.subversion.javahl.types.Depth.empty, null, new org.apache.subversion.javahl.callback.InfoCallback(){

                public void singleInfo(org.apache.subversion.javahl.types.Info info) {
                    infos.add(info);
                }
            });
            return new Info((org.apache.subversion.javahl.types.Info)infos.get(0));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void addToChangelist(String[] paths, String changelist, int depth, String[] changelists) throws ClientException {
        try {
            this.aSVNClient.addToChangelist(new HashSet<String>(Arrays.asList(paths)), changelist, Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void removeFromChangelists(String[] paths, int depth, String[] changelists) throws ClientException {
        try {
            this.aSVNClient.removeFromChangelists(new HashSet<String>(Arrays.asList(paths)), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void getChangelists(String rootPath, String[] changelists, int depth, ChangelistCallback callback) throws ClientException {
        try {
            this.aSVNClient.getChangelists(rootPath, changelists == null ? null : Arrays.asList(changelists), Depth.toADepth(depth), callback);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public String getVersionInfo(String path, String trailUrl, boolean lastChanged) throws ClientException {
        try {
            return this.aSVNClient.getVersionInfo(path, trailUrl, lastChanged);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void upgrade(String path) throws ClientException {
        try {
            this.aSVNClient.upgrade(path);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public static void enableLogging(int logLevel, String logFilePath) {
        org.apache.subversion.javahl.SVNClient.enableLogging(SVNClient.ClientLogLevel.values()[logLevel], logFilePath);
    }

    public static String version() {
        return org.apache.subversion.javahl.SVNClient.version();
    }

    public static int versionMajor() {
        return org.apache.subversion.javahl.SVNClient.versionMajor();
    }

    public static int versionMinor() {
        return org.apache.subversion.javahl.SVNClient.versionMinor();
    }

    public static int versionMicro() {
        return org.apache.subversion.javahl.SVNClient.versionMicro();
    }

    public void lock(String[] paths, String comment, boolean force) throws ClientException {
        try {
            this.aSVNClient.lock(new HashSet<String>(Arrays.asList(paths)), comment, force);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void unlock(String[] paths, boolean force) throws ClientException {
        try {
            this.aSVNClient.unlock(new HashSet<String>(Arrays.asList(paths)), force);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public Info2[] info2(String pathOrUrl, Revision revision, Revision pegRevision, boolean recurse) throws ClientException {
        final ArrayList infos = new ArrayList();
        this.info2(pathOrUrl, revision, pegRevision, Depth.infinityOrEmpty(recurse), null, new InfoCallback(){

            public void singleInfo(Info2 info) {
                infos.add(info);
            }
        });
        return infos.toArray(new Info2[infos.size()]);
    }

    public void info2(String pathOrUrl, Revision revision, Revision pegRevision, int depth, String[] changelists, final InfoCallback callback) throws ClientException {
        try {
            this.aSVNClient.info2(pathOrUrl, revision == null ? null : revision.toApache(), pegRevision == null ? null : pegRevision.toApache(), Depth.toADepth(depth), changelists == null ? null : Arrays.asList(changelists), new org.apache.subversion.javahl.callback.InfoCallback(){

                public void singleInfo(org.apache.subversion.javahl.types.Info aInfo) {
                    callback.singleInfo(aInfo == null ? null : new Info2(aInfo));
                }
            });
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    private RevisionRange[] toRevisionRange(Revision rev1, Revision rev2) {
        RevisionRange[] ranges = new RevisionRange[]{new RevisionRange(rev1, rev2)};
        return ranges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstMsg
    implements CommitMessageCallback {
        private String message;

        ConstMsg(String message) {
            this.message = message;
        }

        @Override
        public String getLogMessage(Set<org.apache.subversion.javahl.CommitItem> items) {
            return this.message;
        }
    }

    private class MyDiffSummaryReceiver
    implements DiffSummaryCallback {
        private DiffSummaryReceiver callback;

        public MyDiffSummaryReceiver(DiffSummaryReceiver callback) {
            this.callback = callback;
        }

        public void onSummary(org.apache.subversion.javahl.DiffSummary summary) {
            this.callback.onSummary(new DiffSummary(summary));
        }
    }

    public static final class LogLevel
    implements SVNClientLogLevel {
    }

    private class PromptUser1Wrapper
    implements UserPasswordCallback {
        PromptUserPassword oldPrompt;
        PromptUserPassword2 oldPrompt2;
        PromptUserPassword3 oldPrompt3;

        PromptUser1Wrapper(PromptUserPassword prompt) {
            this.oldPrompt = prompt;
            if (prompt instanceof PromptUserPassword2) {
                this.oldPrompt2 = (PromptUserPassword2)prompt;
            }
            if (prompt instanceof PromptUserPassword3) {
                this.oldPrompt3 = (PromptUserPassword3)prompt;
            }
        }

        public String getPassword() {
            return this.oldPrompt.getPassword();
        }

        public String getUsername() {
            return this.oldPrompt.getUsername();
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return this.oldPrompt.askQuestion(realm, question, showAnswer);
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return this.oldPrompt.askYesNo(realm, question, yesIsDefault);
        }

        public boolean prompt(String realm, String username) {
            return this.oldPrompt.prompt(realm, username);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            if (this.oldPrompt2 != null) {
                return this.oldPrompt2.askTrustSSLServer(info, allowPermanently);
            }
            return 0;
        }

        public boolean userAllowedSave() {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (this.oldPrompt3 != null) {
                return this.oldPrompt3.askQuestion(realm, question, showAnswer, maySave);
            }
            return this.askQuestion(realm, question, showAnswer);
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            if (this.oldPrompt3 != null) {
                return this.oldPrompt3.prompt(realm, username, maySave);
            }
            return this.prompt(realm, username);
        }
    }
}

