/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.PrefixUtils;
import org.thymeleaf.util.Validate;

public final class Attribute
implements Serializable {
    private static final long serialVersionUID = 7133984802585560958L;
    public static final String XMLNS_PREFIX = "xmlns";
    private final String originalName;
    private final String normalizedName;
    private final String normalizedPrefix;
    private final String unprefixedNormalizedName;
    private final boolean hasPrefix;
    private final boolean xmlnsAttribute;
    private final String xmlnsPrefix;
    private final String value;

    public Attribute(String name, String value) {
        Validate.notNull(name, "Attribute name cannot be null");
        this.originalName = name;
        this.normalizedName = Node.normalizeName(name);
        this.normalizedPrefix = PrefixUtils.getPrefix(this.normalizedName);
        this.unprefixedNormalizedName = PrefixUtils.getUnprefixed(this.normalizedName);
        this.hasPrefix = this.normalizedPrefix != null;
        this.xmlnsAttribute = this.normalizedPrefix != null && this.normalizedPrefix.equals(XMLNS_PREFIX);
        this.xmlnsPrefix = this.xmlnsAttribute ? this.unprefixedNormalizedName : null;
        this.value = value;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public String getNormalizedPrefix() {
        return this.normalizedPrefix;
    }

    public String getUnprefixedNormalizedName() {
        return this.unprefixedNormalizedName;
    }

    public boolean hasPrefix() {
        return this.hasPrefix;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isXmlnsAttribute() {
        return this.xmlnsAttribute;
    }

    public String getXmlnsPrefix() {
        return this.xmlnsPrefix;
    }
}

