/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.Standards;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.PrefixUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Element
extends NestableNode {
    private static final long serialVersionUID = -8434931215899913983L;
    private static final int DEFAULT_ATTRIBUTES_SIZE = 4;
    private final String originalName;
    private final String normalizedName;
    private final String normalizedPrefix;
    private final String unprefixedNormalizedName;
    private final boolean hasPrefix;
    private final boolean minimizableIfWeb;
    private String[] attributeNormalizedNames = null;
    private Attribute[] attributes = null;
    private int attributesLen = 0;

    public Element(String name) {
        this(name, null, null);
    }

    public Element(String name, String documentName) {
        this(name, documentName, null);
    }

    public Element(String name, String documentName, Integer lineNumber) {
        super(documentName, lineNumber);
        Validate.notNull(name, "Element name cannot be null");
        this.originalName = name;
        this.normalizedName = Node.normalizeName(name);
        this.normalizedPrefix = PrefixUtils.getPrefix(this.normalizedName);
        this.unprefixedNormalizedName = PrefixUtils.getUnprefixed(this.normalizedName);
        this.hasPrefix = this.normalizedPrefix != null;
        this.minimizableIfWeb = Arrays.binarySearch(Standards.MINIMIZABLE_XHTML_TAGS, this.normalizedName) >= 0;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public String getNormalizedPrefix() {
        return this.normalizedPrefix;
    }

    public String getUnprefixedNormalizedName() {
        return this.unprefixedNormalizedName;
    }

    public boolean hasPrefix() {
        return this.hasPrefix;
    }

    public boolean isMinimizableIfWeb() {
        return this.minimizableIfWeb;
    }

    public boolean hasAttributes() {
        return this.attributesLen != 0;
    }

    public int numAttributes() {
        return this.attributesLen;
    }

    public boolean hasAttribute(String attributeName) {
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Node.normalizeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNormalizedAttribute(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return true;
        }
        return false;
    }

    public Attribute getAttributeFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i];
        }
        return null;
    }

    public String[] unsafeGetAttributeNormalizedNames() {
        return this.attributeNormalizedNames;
    }

    public Attribute[] unsafeGetAttributes() {
        return this.attributes;
    }

    public String getAttributeOriginalNameFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i].getOriginalName();
        }
        return null;
    }

    public String getAttributeValueFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i].getValue();
        }
        return null;
    }

    public String getAttributeValue(String attributeName) {
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Node.normalizeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                return this.attributes[i].getValue();
            }
        }
        return null;
    }

    public Map<String, Attribute> getAttributeMap() {
        if (this.attributesLen > 0) {
            LinkedHashMap<String, Attribute> attributeMap = new LinkedHashMap<String, Attribute>();
            for (int i = 0; i < this.attributesLen; ++i) {
                attributeMap.put(this.attributeNormalizedNames[i], this.attributes[i]);
            }
            return attributeMap;
        }
        return Collections.emptyMap();
    }

    public void setAttribute(String name, String value) {
        Validate.notNull(name, "Attribute name cannot be null");
        Attribute attribute = new Attribute(name, value);
        String attributeNormalizedName = attribute.getNormalizedName();
        if (this.attributesLen == 0) {
            this.attributeNormalizedNames = new String[4];
            this.attributes = new Attribute[4];
            this.attributeNormalizedNames[0] = attributeNormalizedName;
            this.attributes[0] = attribute;
            this.attributesLen = 1;
            return;
        }
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(attributeNormalizedName)) continue;
            this.attributes[i] = attribute;
            return;
        }
        if (this.attributesLen >= this.attributes.length) {
            int newLength = this.attributesLen * 2;
            String[] newAttributeNormalizedNames = ArrayUtils.copyOf(this.attributeNormalizedNames, newLength);
            Attribute[] newAttributes = ArrayUtils.copyOf(this.attributes, newLength);
            this.attributeNormalizedNames = newAttributeNormalizedNames;
            this.attributes = newAttributes;
        }
        this.attributeNormalizedNames[this.attributesLen] = attributeNormalizedName;
        this.attributes[this.attributesLen] = attribute;
        ++this.attributesLen;
    }

    public void setAttributes(Map<String, String> newAttributes) {
        this.clearAttributes();
        if (newAttributes != null && newAttributes.size() > 0) {
            for (Map.Entry<String, String> newAttributesEntry : newAttributes.entrySet()) {
                this.setAttribute(newAttributesEntry.getKey(), newAttributesEntry.getValue());
            }
        }
    }

    public void clearAttributes() {
        this.attributeNormalizedNames = null;
        this.attributes = null;
        this.attributesLen = 0;
    }

    public void removeAttribute(String attributeName) {
        Validate.notNull(attributeName, "Name of attribute to be removed cannot be null");
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Node.normalizeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                for (int j = i + 1; j < this.attributesLen; ++j) {
                    this.attributeNormalizedNames[j - 1] = this.attributeNormalizedNames[j];
                    this.attributes[j - 1] = this.attributes[j];
                }
                --this.attributesLen;
                return;
            }
        }
    }

    @Override
    void doAdditionalPrecomputeNestableNode(Configuration configuration) {
    }

    public final Element cloneElementNodeWithNewName(NestableNode newParent, String newElementName, boolean cloneProcessors) {
        Element clonedElement = new Element(newElementName);
        this.cloneNodeInternals(clonedElement, newParent, cloneProcessors);
        return clonedElement;
    }

    @Override
    Node createClonedInstance(NestableNode newParent, boolean cloneProcessors) {
        return new Element(this.originalName, this.getDocumentName(), this.getLineNumber());
    }

    @Override
    void doCloneNestableNodeInternals(NestableNode node, NestableNode newParent, boolean cloneProcessors) {
        Element element = (Element)node;
        if (this.attributesLen > 0) {
            element.attributeNormalizedNames = ArrayUtils.copyOf(this.attributeNormalizedNames, this.attributesLen);
            element.attributes = ArrayUtils.copyOf(this.attributes, this.attributesLen);
            element.attributesLen = this.attributesLen;
        }
    }
}

