/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DateUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Calendars {
    public static Calendar create(Object year, Object month, Object day) {
        return DateUtils.create(year, month, day);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute) {
        return DateUtils.create(year, month, day, hour, minute);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second) {
        return DateUtils.create(year, month, day, hour, minute, second);
    }

    public static Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond);
    }

    public static Calendar createNow() {
        return DateUtils.createNow();
    }

    public static Calendar createToday() {
        return DateUtils.createToday();
    }

    public String format(Calendar target) {
        try {
            return DateUtils.format(target, Calendars.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting calendar with standard format for locale " + Calendars.getLocale(), e);
        }
    }

    public String[] arrayFormat(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.format(calendar));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.format(calendar));
        }
        return result;
    }

    public String format(Calendar target, String pattern) {
        try {
            return DateUtils.format(target, pattern, Calendars.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting calendar with format pattern \"" + pattern + "\"", e);
        }
    }

    public String[] arrayFormat(Object[] target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Calendar)target[i], pattern);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Calendar> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.format(calendar, pattern));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Calendar> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.format(calendar, pattern));
        }
        return result;
    }

    public Integer day(Calendar target) {
        return DateUtils.day(target);
    }

    public Integer[] arrayDay(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.day((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listDay(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.day(calendar));
        }
        return result;
    }

    public Set<Integer> setDay(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.day(calendar));
        }
        return result;
    }

    public Integer month(Calendar target) {
        return DateUtils.month(target);
    }

    public Integer[] arrayMonth(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.month((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMonth(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.month(calendar));
        }
        return result;
    }

    public Set<Integer> setMonth(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.month(calendar));
        }
        return result;
    }

    public String monthName(Calendar target) {
        return DateUtils.monthName(target, Calendars.getLocale());
    }

    public String[] arrayMonthName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthName((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listMonthName(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.monthName(calendar));
        }
        return result;
    }

    public Set<String> setMonthName(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.monthName(calendar));
        }
        return result;
    }

    public String monthNameShort(Calendar target) {
        return DateUtils.monthNameShort(target, Calendars.getLocale());
    }

    public String[] arrayMonthNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthNameShort((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listMonthNameShort(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.monthNameShort(calendar));
        }
        return result;
    }

    public Set<String> setMonthNameShort(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.monthNameShort(calendar));
        }
        return result;
    }

    public Integer year(Calendar target) {
        return DateUtils.year(target);
    }

    public Integer[] arrayYear(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.year((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listYear(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.year(calendar));
        }
        return result;
    }

    public Set<Integer> setYear(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.year(calendar));
        }
        return result;
    }

    public Integer dayOfWeek(Calendar target) {
        return DateUtils.dayOfWeek(target);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeek((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listDayOfWeek(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeek(calendar));
        }
        return result;
    }

    public Set<Integer> setDayOfWeek(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeek(calendar));
        }
        return result;
    }

    public String dayOfWeekName(Calendar target) {
        return DateUtils.dayOfWeekName(target, Calendars.getLocale());
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekName((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekName(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekName(calendar));
        }
        return result;
    }

    public Set<String> setDayOfWeekName(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekName(calendar));
        }
        return result;
    }

    public String dayOfWeekNameShort(Calendar target) {
        return DateUtils.dayOfWeekNameShort(target, Calendars.getLocale());
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekNameShort((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekNameShort(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekNameShort(calendar));
        }
        return result;
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekNameShort(calendar));
        }
        return result;
    }

    public Integer hour(Calendar target) {
        return DateUtils.hour(target);
    }

    public Integer[] arrayHour(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.hour((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listHour(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.hour(calendar));
        }
        return result;
    }

    public Set<Integer> setHour(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.hour(calendar));
        }
        return result;
    }

    public Integer minute(Calendar target) {
        return DateUtils.minute(target);
    }

    public Integer[] arrayMinute(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.minute((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMinute(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.minute(calendar));
        }
        return result;
    }

    public Set<Integer> setMinute(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.minute(calendar));
        }
        return result;
    }

    public Integer second(Calendar target) {
        return DateUtils.second(target);
    }

    public Integer[] arraySecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.second((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listSecond(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.second(calendar));
        }
        return result;
    }

    public Set<Integer> setSecond(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.second(calendar));
        }
        return result;
    }

    public Integer millisecond(Calendar target) {
        return DateUtils.millisecond(target);
    }

    public Integer[] arrayMillisecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.millisecond((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMillisecond(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Calendar calendar : target) {
            result.add(this.millisecond(calendar));
        }
        return result;
    }

    public Set<Integer> setMillisecond(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Calendar calendar : target) {
            result.add(this.millisecond(calendar));
        }
        return result;
    }

    private static Locale getLocale() {
        Locale locale = TemplateEngine.threadLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

