/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeNameProcessorMatcher
implements IAttributeNameProcessorMatcher {
    private final String attributeName;
    private final String elementNameFilter;
    private final Map<String, String> attributeValuesByNameFilter;

    public AttributeNameProcessorMatcher(String attributeName) {
        this(attributeName, null, null);
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter) {
        this(attributeName, elementNameFilter, null);
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter, String filterAttributeName, String filterAttributeValue) {
        this(attributeName, elementNameFilter, Collections.singletonMap(filterAttributeName, filterAttributeValue));
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter, Map<String, String> attributeValuesByNameFilter) {
        Validate.notEmpty(attributeName, "Attribute name cannot be null or empty");
        this.attributeName = attributeName;
        this.elementNameFilter = Node.normalizeName(elementNameFilter);
        if (attributeValuesByNameFilter == null || attributeValuesByNameFilter.size() == 0) {
            this.attributeValuesByNameFilter = null;
        } else {
            HashMap<String, String> newAttributeValuesByNameFilter = new HashMap<String, String>(attributeValuesByNameFilter.size() + 1, 1.0f);
            newAttributeValuesByNameFilter.putAll(attributeValuesByNameFilter);
            this.attributeValuesByNameFilter = Collections.unmodifiableMap(newAttributeValuesByNameFilter);
        }
    }

    @Override
    public String getAttributeName(ProcessorMatchingContext context) {
        return Node.applyDialectPrefix(this.attributeName, context.getDialectPrefix());
    }

    public String getElementNameFilter() {
        return this.elementNameFilter;
    }

    public Map<String, String> getAttributeValuesByNameFilter() {
        return this.attributeValuesByNameFilter;
    }

    @Override
    public boolean matches(Node node, ProcessorMatchingContext context) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String completeAttributeName = this.getAttributeName(context);
        if (!element.hasAttribute(completeAttributeName)) {
            return false;
        }
        if (this.elementNameFilter != null && !element.getNormalizedName().equals(this.elementNameFilter)) {
            return false;
        }
        if (this.attributeValuesByNameFilter != null) {
            for (Map.Entry<String, String> filterAttributeEntry : this.attributeValuesByNameFilter.entrySet()) {
                String elementAttributeValue;
                String filterAttributeName = filterAttributeEntry.getKey();
                String filterAttributeValue = filterAttributeEntry.getValue();
                if (!(!element.hasAttribute(filterAttributeName) ? filterAttributeValue != null : ((elementAttributeValue = element.getAttributeValue(filterAttributeName)) == null ? filterAttributeValue != null : !elementAttributeValue.equals(filterAttributeValue)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final Class<? extends Element> appliesTo() {
        return Element.class;
    }
}

