/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.MessageResolutionUtils;
import org.thymeleaf.util.Validate;

public final class StandardMessageResolutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(StandardMessageResolutionUtils.class);
    private static final String THYMELEAF_MARKUP_SUFFIX = ".thtml";
    private static final String XML_SUFFIX = ".xml";
    private static final String XHTML_SUFFIX = ".xhtml";
    private static final String HTML_SUFFIX = ".html";
    private static final String HTM_SUFFIX = ".htm";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String TEMPLATE_CACHE_PREFIX = "{template_msg}";

    public static String resolveMessageForTemplate(Arguments arguments, String key, Object[] messageParameters, Properties defaultMessages) {
        String messageValue;
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(arguments.getContext().getLocale(), "Locale in context cannot be null");
        Validate.notNull(key, "Message key cannot be null");
        Locale locale = arguments.getContext().getLocale();
        String templateName = arguments.getTemplateResolution().getTemplateName();
        String cacheKey = TEMPLATE_CACHE_PREFIX + templateName + "_" + locale.toString();
        Properties properties = null;
        ICache<String, Properties> messagesCache = null;
        ICacheManager cacheManager = arguments.getConfiguration().getCacheManager();
        if (cacheManager != null && (messagesCache = cacheManager.getMessageCache()) != null) {
            properties = messagesCache.get(cacheKey);
        }
        if (properties == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("[THYMELEAF][{}] Resolving uncached messages for template \"{}\" and locale \"{}\". Messages will be retrieved from files", new Object[]{TemplateEngine.threadIndex(), templateName, locale});
            }
            properties = StandardMessageResolutionUtils.loadMessagesForTemplate(arguments, defaultMessages);
            if (messagesCache != null) {
                messagesCache.put(cacheKey, properties);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Resolving messages for template \"{}\" and locale \"{}\". Messages are CACHED", new Object[]{TemplateEngine.threadIndex(), templateName, locale});
        }
        if ((messageValue = properties.getProperty(key)) == null) {
            return null;
        }
        if (messageParameters == null || messageParameters.length == 0) {
            return messageValue;
        }
        MessageFormat messageFormat = new MessageFormat(messageValue, locale);
        return messageFormat.format(messageParameters);
    }

    private static Properties loadMessagesForTemplate(Arguments arguments, Properties defaultMessages) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(arguments.getContext().getLocale(), "Locale in context cannot be null");
        String resourceName = arguments.getTemplateResolution().getResourceName();
        IResourceResolver resourceResolver = arguments.getTemplateResolution().getResourceResolver();
        Locale locale = arguments.getContext().getLocale();
        String templateBaseName = StandardMessageResolutionUtils.getTemplateFileNameBase(resourceName);
        return MessageResolutionUtils.loadCombinedMessagesFilesFromBaseName(arguments, resourceResolver, templateBaseName, locale, defaultMessages);
    }

    private static String getTemplateFileNameBase(String templateFileName) {
        if (templateFileName.endsWith(THYMELEAF_MARKUP_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - THYMELEAF_MARKUP_SUFFIX.length());
        }
        if (templateFileName.endsWith(HTML_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - HTML_SUFFIX.length());
        }
        if (templateFileName.endsWith(XHTML_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - XHTML_SUFFIX.length());
        }
        if (templateFileName.endsWith(HTM_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - HTM_SUFFIX.length());
        }
        if (templateFileName.endsWith(XML_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - XML_SUFFIX.length());
        }
        if (templateFileName.endsWith(JSP_SUFFIX)) {
            return templateFileName.substring(0, templateFileName.length() - JSP_SUFFIX.length());
        }
        return templateFileName;
    }

    private StandardMessageResolutionUtils() {
    }
}

