/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.List;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryOperationExpression
extends ComplexExpression {
    private static final long serialVersionUID = 7524261639178859585L;
    private final Expression left;
    private final Expression right;

    protected BinaryOperationExpression(Expression left, Expression right) {
        Validate.notNull(left, "Left-side expression cannot be null");
        Validate.notNull(right, "Right-side expression cannot be null");
        this.left = left;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    protected String getStringRepresentation(String operator) {
        StringBuilder sb = new StringBuilder();
        if (this.left instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.left);
            sb.append(')');
        } else {
            sb.append(this.left);
        }
        sb.append(' ');
        sb.append(operator);
        sb.append(' ');
        if (this.right instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.right);
            sb.append(')');
        } else {
            sb.append(this.right);
        }
        return sb.toString();
    }

    protected static List<ExpressionParsingNode> composeBinaryOperationExpression(List<ExpressionParsingNode> decomposition, int inputIndex, String[] operators, boolean[] leniencies, Class<? extends BinaryOperationExpression>[] operationClasses) {
        String input = decomposition.get(inputIndex).getInput();
        if (input.equals("")) {
            return null;
        }
        String scannedInput = input.toLowerCase();
        boolean checkPreviousOperatorOccurence = false;
        List<ExpressionParsingNode> result = decomposition;
        do {
            int operatorIndex = -1;
            int operatorPosFrom = -1;
            int operatorPosTo = Integer.MAX_VALUE;
            int operatorLen = 0;
            for (int i = 0; i < operators.length; ++i) {
                int currentOperatorPosFrom = scannedInput.lastIndexOf(operators[i]);
                if (currentOperatorPosFrom == -1) continue;
                int currentOperatorLen = operators[i].length();
                int currentOperatorPosTo = currentOperatorPosFrom + currentOperatorLen;
                if (operatorPosFrom != -1 && operatorPosTo >= currentOperatorPosFrom && (currentOperatorLen <= operatorLen || currentOperatorPosTo < operatorPosTo)) continue;
                operatorPosFrom = currentOperatorPosFrom;
                operatorLen = operators[i].length();
                operatorPosTo = currentOperatorPosFrom + operatorLen;
                operatorIndex = i;
            }
            if (operatorPosFrom == -1) {
                return decomposition;
            }
            result = BinaryOperationExpression.doComposeBinaryOperationExpression(decomposition, inputIndex, operators[operatorIndex], operationClasses[operatorIndex], input, operatorPosFrom);
            if (leniencies[operatorIndex]) {
                if (result == null) {
                    checkPreviousOperatorOccurence = true;
                    scannedInput = scannedInput.substring(0, operatorPosFrom);
                    continue;
                }
                checkPreviousOperatorOccurence = false;
                continue;
            }
            checkPreviousOperatorOccurence = false;
        } while (checkPreviousOperatorOccurence);
        return result;
    }

    private static List<ExpressionParsingNode> doComposeBinaryOperationExpression(List<ExpressionParsingNode> decomposition, int inputIndex, String operator, Class<? extends BinaryOperationExpression> operationClass, String input, int operatorPos) {
        List<ExpressionParsingNode> result = decomposition;
        String leftStr = input.substring(0, operatorPos).trim();
        String rightStr = input.substring(operatorPos + operator.length()).trim();
        if (leftStr.equals("") || rightStr.equals("")) {
            return null;
        }
        int leftIndex = Expression.placeHolderToIndex(leftStr);
        if (leftIndex == -1) {
            leftIndex = result.size();
            result.add(new ExpressionParsingNode(leftStr));
        }
        if ((result = ComplexExpression.composeComplexExpressions(result, leftIndex)) == null) {
            return null;
        }
        int rightIndex = Expression.placeHolderToIndex(rightStr);
        if (rightIndex == -1) {
            rightIndex = result.size();
            result.add(new ExpressionParsingNode(rightStr));
        }
        if ((result = ComplexExpression.composeComplexExpressions(result, rightIndex)) == null) {
            return null;
        }
        ExpressionParsingNode leftEPN = result.get(leftIndex);
        Expression leftExpr = leftEPN.getExpression();
        if (leftExpr == null) {
            return null;
        }
        ExpressionParsingNode rightEPN = result.get(rightIndex);
        Expression rightExpr = rightEPN.getExpression();
        if (rightExpr == null) {
            return null;
        }
        try {
            BinaryOperationExpression operationExpression = operationClass.getDeclaredConstructor(Expression.class, Expression.class).newInstance(leftExpr, rightExpr);
            result.set(inputIndex, new ExpressionParsingNode(operationExpression));
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during creation of Binary Operation expression for operator: \"" + operator + "\"", e);
        }
        return result;
    }
}

