/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.Token;

final class ExpressionParsingNode {
    private final String input;
    private final Token token;
    private final Expression expression;
    private final Assignation assignation;
    private final AssignationSequence assignationSequence;
    private final ExpressionSequence expressionSequence;

    ExpressionParsingNode(String input) {
        this.input = input.trim();
        this.token = null;
        this.expression = null;
        this.assignation = null;
        this.assignationSequence = null;
        this.expressionSequence = null;
    }

    ExpressionParsingNode(Expression expression) {
        this.expression = expression;
        this.token = null;
        this.input = null;
        this.assignation = null;
        this.assignationSequence = null;
        this.expressionSequence = null;
    }

    ExpressionParsingNode(Token token) {
        this.token = token;
        this.expression = null;
        this.input = null;
        this.assignation = null;
        this.assignationSequence = null;
        this.expressionSequence = null;
    }

    ExpressionParsingNode(Assignation assignation) {
        this.assignation = assignation;
        this.token = null;
        this.expression = null;
        this.input = null;
        this.assignationSequence = null;
        this.expressionSequence = null;
    }

    ExpressionParsingNode(AssignationSequence assignationSequence) {
        this.assignationSequence = assignationSequence;
        this.assignation = null;
        this.token = null;
        this.expression = null;
        this.input = null;
        this.expressionSequence = null;
    }

    ExpressionParsingNode(ExpressionSequence expressionSequence) {
        this.expressionSequence = expressionSequence;
        this.assignationSequence = null;
        this.assignation = null;
        this.token = null;
        this.expression = null;
        this.input = null;
    }

    boolean isInput() {
        return this.input != null;
    }

    boolean isAssignation() {
        return this.assignation != null;
    }

    boolean isAssignationSequence() {
        return this.assignationSequence != null;
    }

    boolean isExpressionSequence() {
        return this.expressionSequence != null;
    }

    boolean isToken() {
        return this.token != null;
    }

    boolean isExpression() {
        return this.expression != null;
    }

    boolean isSimpleExpression() {
        return this.expression != null && this.expression instanceof SimpleExpression;
    }

    boolean ComplexExpression() {
        return this.expression != null && this.expression instanceof ComplexExpression;
    }

    String getInput() {
        return this.input;
    }

    Expression getExpression() {
        return this.expression;
    }

    Token getToken() {
        return this.token;
    }

    Assignation getAssignation() {
        return this.assignation;
    }

    AssignationSequence getAssignationSequence() {
        return this.assignationSequence;
    }

    ExpressionSequence getExpressionSequence() {
        return this.expressionSequence;
    }

    public String toString() {
        return this.isExpression() ? "[" + this.expression.getStringRepresentation() + "]" : (this.isToken() ? this.token.getStringRepresentation() : (this.isAssignation() ? this.assignation.getStringRepresentation() : (this.isAssignationSequence() ? this.assignationSequence.getStringRepresentation() : (this.isExpressionSequence() ? this.expressionSequence.getStringRepresentation() : this.input))));
    }
}

