/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(LinkExpression.class);
    private static final long serialVersionUID = -564516592085017252L;
    static final char SELECTOR = '@';
    private static final char PARAMS_START_CHAR = '(';
    private static final char PARAMS_END_CHAR = ')';
    private static final Pattern LINK_PATTERN = Pattern.compile("^\\s*\\@\\{(.+?)\\}\\s*$", 32);
    private static final String URL_PARAM_NO_VALUE = "%%%__NO_VALUE__%%%";
    private final Expression base;
    private final AssignationSequence parameters;

    public LinkExpression(Expression base, AssignationSequence parameters) {
        Validate.notNull(base, "Base cannot be null");
        this.base = base;
        this.parameters = parameters;
    }

    public Expression getBase() {
        return this.base;
    }

    public AssignationSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append('{');
        sb.append(this.base);
        if (this.hasParameters()) {
            sb.append('(');
            sb.append(this.parameters.getStringRepresentation());
            sb.append(')');
        }
        sb.append('}');
        return sb.toString();
    }

    static LinkExpression parseLink(String input) {
        Matcher matcher = LINK_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String content = matcher.group(1);
        if (content == null || content.trim().equals("")) {
            return null;
        }
        String trimmedInput = content.trim();
        if (trimmedInput.endsWith(String.valueOf(')'))) {
            boolean inLiteral = false;
            int nestParLevel = 0;
            for (int i = trimmedInput.length() - 1; i >= 0; --i) {
                char c = trimmedInput.charAt(i);
                if (c == '\'') {
                    if (i != 0 && content.charAt(i - 1) == '\\') continue;
                    inLiteral = !inLiteral;
                    continue;
                }
                if (c == ')') {
                    ++nestParLevel;
                    continue;
                }
                if (c != '(') continue;
                if (--nestParLevel < 0) {
                    return null;
                }
                if (nestParLevel != 0) continue;
                if (i == 0) {
                    return null;
                }
                String base = trimmedInput.substring(0, i);
                String parameters = trimmedInput.substring(i + 1, trimmedInput.length() - 1);
                Expression baseExpr = LinkExpression.computeBase(base);
                if (baseExpr == null) {
                    return null;
                }
                AssignationSequence parametersAssigSeq = AssignationSequence.parse(parameters, true);
                if (parametersAssigSeq == null) {
                    return null;
                }
                return new LinkExpression(baseExpr, parametersAssigSeq);
            }
            return null;
        }
        Expression baseExpr = LinkExpression.computeBase(trimmedInput);
        if (baseExpr == null) {
            return null;
        }
        return new LinkExpression(baseExpr, null);
    }

    private static Expression computeBase(String baseStr) {
        Token token = Token.parse(baseStr);
        if (token != null) {
            return TextLiteralExpression.parseTextLiteral(token.getValue());
        }
        return Expression.parse(baseStr);
    }

    static Object executeLink(Configuration configuration, IProcessingContext processingContext, LinkExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating link: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Expression baseExpression = expression.getBase();
        Object base = Expression.execute(configuration, processingContext, baseExpression, expressionEvaluator);
        if ((base = LiteralValue.unwrap(base)) == null || !(base instanceof String) || ((String)base).trim().equals("")) {
            throw new TemplateProcessingException("Base for message resolution must be a non-null and non-empty String (currently: " + (base == null ? null : base.getClass().getName()) + ")");
        }
        String linkBase = (String)base;
        if (!(LinkExpression.isWebContext(processingContext.getContext()) || LinkExpression.isLinkBaseAbsolute(linkBase) || LinkExpression.isLinkBaseServerRelative(linkBase))) {
            throw new TemplateProcessingException("Link base \"" + linkBase + "\" cannot be context relative (/) unless you implement the " + IWebContext.class.getName() + " interface (context is of class: " + processingContext.getContext().getClass().getName() + ")");
        }
        Map<String, List<Object>> parameters = expression.hasParameters() ? LinkExpression.resolveParameters(configuration, processingContext, expression.getParameters(), expressionEvaluator) : Collections.EMPTY_MAP;
        int hashPosition = linkBase.indexOf(35);
        String urlFragment = "";
        if (hashPosition > 0) {
            urlFragment = linkBase.substring(hashPosition);
            linkBase = linkBase.substring(0, hashPosition);
        }
        int questionMarkPosition = linkBase.indexOf("?");
        StringBuffer parametersBuffer = new StringBuffer();
        for (Map.Entry<String, List<Object>> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            List<Object> parameterValues = parameterEntry.getValue();
            for (Object parameterObjectValue : parameterValues) {
                String parameterValue;
                if (parametersBuffer.length() == 0) {
                    if (questionMarkPosition == -1) {
                        parametersBuffer.append("?");
                    } else {
                        parametersBuffer.append("&");
                    }
                } else {
                    parametersBuffer.append("&");
                }
                String string = parameterValue = parameterObjectValue == null ? "" : parameterObjectValue.toString();
                if (URL_PARAM_NO_VALUE.equals(parameterValue)) {
                    parametersBuffer.append(parameterName);
                    continue;
                }
                try {
                    parametersBuffer.append(parameterName + "=" + URLEncoder.encode(parameterValue, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new TemplateProcessingException("Exception while processing link parameters", e);
                }
            }
        }
        if (LinkExpression.isLinkBaseAbsolute(linkBase)) {
            return linkBase + parametersBuffer.toString() + urlFragment;
        }
        if (!LinkExpression.isWebContext(processingContext.getContext()) && LinkExpression.isLinkBaseServerRelative(linkBase)) {
            return linkBase.substring(1) + parametersBuffer.toString() + urlFragment;
        }
        IWebContext webContext = (IWebContext)processingContext.getContext();
        String sessionFragment = "";
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpSession session = webContext.getHttpSession();
        if (null != session) {
            String sessionID = session.getId();
            if (!request.isRequestedSessionIdFromCookie() && !LinkExpression.isUserAgentGoogleBot(request)) {
                sessionFragment = ";jsessionid=" + sessionID;
            }
        }
        if (LinkExpression.isLinkBaseContextRelative(linkBase)) {
            String contextName = request.getContextPath();
            if (questionMarkPosition == -1) {
                return contextName + linkBase + sessionFragment + parametersBuffer.toString() + urlFragment;
            }
            String linkBasePart1 = linkBase.substring(0, questionMarkPosition);
            String linkBasePart2 = linkBase.substring(questionMarkPosition);
            return contextName + linkBasePart1 + sessionFragment + linkBasePart2 + parametersBuffer.toString() + urlFragment;
        }
        if (LinkExpression.isLinkBaseServerRelative(linkBase)) {
            if (questionMarkPosition == -1) {
                return linkBase.substring(1) + sessionFragment + parametersBuffer.toString() + urlFragment;
            }
            String linkBasePart1 = linkBase.substring(0, questionMarkPosition);
            String linkBasePart2 = linkBase.substring(questionMarkPosition);
            return linkBasePart1.substring(1) + sessionFragment + linkBasePart2 + parametersBuffer.toString() + urlFragment;
        }
        return linkBase + sessionFragment + parametersBuffer.toString() + urlFragment;
    }

    private static boolean isWebContext(IContext context) {
        return context instanceof IWebContext;
    }

    private static boolean isLinkBaseAbsolute(String linkBase) {
        return linkBase.contains("://") || linkBase.toLowerCase().startsWith("mailto:");
    }

    private static boolean isLinkBaseContextRelative(String linkBase) {
        return linkBase.startsWith("/");
    }

    private static boolean isLinkBaseServerRelative(String linkBase) {
        return linkBase.startsWith("~/");
    }

    private static Map<String, List<Object>> resolveParameters(Configuration configuration, IProcessingContext processingContext, AssignationSequence assignationValues, IStandardVariableExpressionEvaluator expressionEvaluator) {
        LinkedHashMap<String, List<Object>> parameters = new LinkedHashMap<String, List<Object>>(assignationValues.size() + 1, 1.0f);
        for (Assignation assignationValue : assignationValues) {
            String parameterName = assignationValue.getLeft().getValue();
            Expression parameterExpression = assignationValue.getRight();
            ArrayList<String> currentParameterValues = (ArrayList<String>)parameters.get(parameterName);
            if (currentParameterValues == null) {
                currentParameterValues = new ArrayList<String>();
                parameters.put(parameterName, currentParameterValues);
            }
            if (parameterExpression == null) {
                currentParameterValues.add(URL_PARAM_NO_VALUE);
                continue;
            }
            Object value = Expression.execute(configuration, processingContext, parameterExpression, expressionEvaluator);
            if (value == null) {
                currentParameterValues.add("");
                continue;
            }
            currentParameterValues.addAll(LinkExpression.convertParameterValueToList(LiteralValue.unwrap(value)));
        }
        return parameters;
    }

    private static List<Object> convertParameterValueToList(Object parameterValue) {
        if (parameterValue instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object obj : (Iterable)parameterValue) {
                result.add(obj);
            }
            return result;
        }
        if (parameterValue.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (parameterValue instanceof byte[]) {
                for (byte obj : (byte[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof short[]) {
                for (short obj : (short[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof int[]) {
                for (int obj : (int[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof long[]) {
                for (long obj : (long[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof float[]) {
                for (float obj : (float[])parameterValue) {
                    result.add(Float.valueOf(obj));
                }
            } else if (parameterValue instanceof double[]) {
                for (double obj : (double[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof boolean[]) {
                for (boolean obj : (boolean[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof char[]) {
                for (char obj : (char[])parameterValue) {
                    result.add(Character.valueOf(obj));
                }
            } else {
                for (Object obj : (Object[])parameterValue) {
                    result.add(obj);
                }
            }
            return result;
        }
        return Collections.singletonList(parameterValue);
    }

    private static boolean isUserAgentGoogleBot(HttpServletRequest request) {
        Enumeration userAgentHeaders = request.getHeaders("User-Agent");
        if (userAgentHeaders == null) {
            return false;
        }
        while (userAgentHeaders.hasMoreElements()) {
            String header = (String)userAgentHeaders.nextElement();
            if (header == null || !header.toLowerCase().contains("googlebot")) continue;
            return true;
        }
        return false;
    }
}

