/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

public final class NumberLiteralExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(NumberLiteralExpression.class);
    private static final long serialVersionUID = -3729844055243242571L;
    static final char DECIMAL_POINT = '.';
    private final BigDecimal value;

    public NumberLiteralExpression(String value) {
        Validate.notNull(value, "Value cannot be null");
        this.value = new BigDecimal(value);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getStringRepresentation() {
        return this.value.toPlainString();
    }

    static NumberLiteralExpression parseNumberLiteral(String input) {
        return new NumberLiteralExpression(input);
    }

    static Object executeNumberLiteral(IProcessingContext processingContext, NumberLiteralExpression expression) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating number literal: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

