/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -8085738202412415337L;
    private static final Logger logger = LoggerFactory.getLogger(OrExpression.class);
    private static final String OPERATOR = "or";
    private static final String[] OPERATORS = new String[]{"or"};
    private static final boolean[] LENIENCIES = new boolean[]{false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{OrExpression.class};

    public OrExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(OPERATOR);
    }

    protected static List<ExpressionParsingNode> composeOrExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        return OrExpression.composeBinaryOperationExpression(decomposition, inputIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES);
    }

    static Object executeOr(Configuration configuration, IProcessingContext processingContext, OrExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating OR expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(configuration, processingContext, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(configuration, processingContext, expression.getRight(), expressionEvaluator);
        boolean leftBooleanValue = ObjectUtils.evaluateAsBoolean(leftValue);
        boolean rightBooleanValue = ObjectUtils.evaluateAsBoolean(rightValue);
        return leftBooleanValue || rightBooleanValue;
    }
}

