/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.thymeleaf.util.Validate;

public final class Token
implements Serializable {
    private static final long serialVersionUID = 1375274391088787250L;
    private static final String VALID_TOKEN_NAME_START_END_CHARS = "~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}";
    private static final String VALID_TOKEN_NAME_CHARS = "~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\} ";
    private static final String TOKEN_NAME_START_END_CHARS = "[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}]";
    private static final String TOKEN_NAME_CHARS = "[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\} ]";
    private static final String TOKEN = "[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}](?:(?:[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\} ]*?)[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}])?";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}](?:(?:[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\} ]*?)[~:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd\\-\\.0-9/\\\\\u00b7\u0300-\u036f\u203f-\u2040#\\[\\]\\{\\}])?$");
    private final String value;

    Token(String value) {
        Validate.notNull(value, "Value cannot be null");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getStringRepresentation() {
        return this.value;
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    public static Token parse(String input) {
        if (input == null) {
            return null;
        }
        if (TOKEN_PATTERN.matcher(input.trim()).matches()) {
            return new Token(input.trim());
        }
        return null;
    }
}

