/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.text;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.TextNodeProcessorMatcher;
import org.thymeleaf.processor.text.AbstractTextNodeProcessor;
import org.thymeleaf.standard.inliner.IStandardTextInliner;

public final class StandardTextInliningTextProcessor
extends AbstractTextNodeProcessor {
    public static final int ATTR_PRECEDENCE = 100;
    public static final TextNodeProcessorMatcher MATCHER = new TextNodeProcessorMatcher();

    public StandardTextInliningTextProcessor() {
        super(new TextNodeProcessorMatcher());
    }

    public int getPrecedence() {
        return 100;
    }

    public ProcessorResult processTextNode(Arguments arguments, AbstractTextNode textNode) {
        if (arguments.getProcessOnlyElementNodes()) {
            throw new TemplateProcessingException("Cannot execute text inlining processor: Text processors are not active");
        }
        Object inliner = arguments.getLocalVariable("%STANDARD_INLINER%");
        if (inliner == null) {
            throw new TemplateProcessingException("Cannot execute text inlining processor: No inliner has been set as a local variable");
        }
        if (!(inliner instanceof IStandardTextInliner)) {
            throw new TemplateProcessingException("Cannot execute text inlining processor: Inliner set does not implement " + IStandardTextInliner.class.getName() + " (it is an object of class " + inliner.getClass().getName() + ")");
        }
        ((IStandardTextInliner)inliner).inline(arguments, textNode);
        return ProcessorResult.OK;
    }
}

