/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.PatternSpec;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolutionValidity;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateResolver
implements ITemplateResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTemplateResolver.class);
    private String name = null;
    private Integer order = null;
    private final PatternSpec resolvablePatternSpec = new PatternSpec();
    private volatile boolean initialized = false;

    protected final boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.name == null) {
                this.name = this.getClass().getName();
            }
            logger.info("[THYMELEAF] INITIALIZING TEMPLATE RESOLVER: " + this.name);
            this.resolvablePatternSpec.initialize();
            this.initializeSpecific();
            this.initialized = true;
            logger.info("[THYMELEAF] TEMPLATE RESOLVER INITIALIZED OK");
        }
    }

    protected void initializeSpecific() {
    }

    protected final void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template resolver when it has already been initialized");
        }
    }

    protected final void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Template Resolver has not been initialized");
        }
    }

    @Override
    public String getName() {
        this.checkInitialized();
        return this.name;
    }

    protected String unsafeGetName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkNotInitialized();
        this.name = name;
    }

    @Override
    public Integer getOrder() {
        this.checkInitialized();
        return this.order;
    }

    protected Integer unsafeGetOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.checkNotInitialized();
        this.order = order;
    }

    public PatternSpec getResolvablePatternSpec() {
        this.checkInitialized();
        return this.resolvablePatternSpec;
    }

    public Set<String> getResolvablePatterns() {
        this.checkInitialized();
        return this.resolvablePatternSpec.getPatterns();
    }

    public void setResolvablePatterns(Set<String> resolvablePatterns) {
        this.checkNotInitialized();
        this.resolvablePatternSpec.setPatterns(resolvablePatterns);
    }

    @Override
    public TemplateResolution resolveTemplate(TemplateProcessingParameters templateProcessingParameters) {
        this.checkInitialized();
        Validate.notNull(templateProcessingParameters, "Template Processing Parameters cannot be null");
        if (!this.computeResolvable(templateProcessingParameters)) {
            return null;
        }
        return new TemplateResolution(templateProcessingParameters.getTemplateName(), this.computeResourceName(templateProcessingParameters), this.computeResourceResolver(templateProcessingParameters), this.computeCharacterEncoding(templateProcessingParameters), this.computeTemplateMode(templateProcessingParameters), this.computeValidity(templateProcessingParameters));
    }

    protected boolean computeResolvable(TemplateProcessingParameters templateProcessingParameters) {
        if (this.resolvablePatternSpec.getPatterns().isEmpty()) {
            return true;
        }
        return this.resolvablePatternSpec.matches(templateProcessingParameters.getTemplateName());
    }

    protected abstract String computeResourceName(TemplateProcessingParameters var1);

    protected abstract IResourceResolver computeResourceResolver(TemplateProcessingParameters var1);

    protected abstract String computeCharacterEncoding(TemplateProcessingParameters var1);

    protected abstract String computeTemplateMode(TemplateProcessingParameters var1);

    protected abstract ITemplateResolutionValidity computeValidity(TemplateProcessingParameters var1);
}

