/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public class JhlNotificationHandler
extends SVNNotificationHandler
implements Notify2 {
    private boolean receivedSomeChange;
    private boolean sentFirstTxdelta;
    private int updates;
    private int adds;
    private int deletes;
    private int conflicts;
    private int merges;
    private int exists;
    private int propConflicts;
    private int treeConflicts;
    private int propMerges;
    private int propUpdates;
    private boolean inExternal;
    private boolean holdStats;
    private String lastUpdate;
    private String lastExternalUpdate;
    private boolean statsCommand = false;
    private static final int COMMIT_ACROSS_WC_COMPLETED = -11;
    private static final int ENDED_ABNORMAL = -1;

    public void onNotify(NotifyInformation info) {
        boolean notify = true;
        switch (info.getAction()) {
            case -1: {
                if (this.command == 3) {
                    this.logError(Messages.bind("notify.commit.abnormal"));
                } else {
                    this.logError(Messages.bind("notify.end.abnormal"));
                }
                if (info.getErrMsg() != null) {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 29: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging (from foreign repository) r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between foreign repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case 28: {
                if (info.getMergeRange() != null) {
                    if (info.getMergeRange().getFromRevision().equals((Object)info.getMergeRange().getToRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " into " + info.getPath());
                    } else if (info.getMergeRange().getToRevision().equals((Object)Revision.HEAD) || RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getToRevision()) > RevisionRange.getRevisionAsLong((Revision)info.getMergeRange().getFromRevision())) {
                        this.logMessage("--- Merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    } else {
                        this.logMessage("--- Reverse-merging r" + info.getMergeRange().getFromRevision().toString() + " through r" + info.getMergeRange().getToRevision().toString() + " into " + info.getPath());
                    }
                } else {
                    this.logMessage("--- Merging differences between repository URLs into " + info.getPath());
                }
                notify = false;
                break;
            }
            case 7: {
                this.logMessage(Messages.bind("notify.skipped", info.getPath()));
                notify = false;
                break;
            }
            case 23: {
                if (info.getErrMsg() == null) {
                    this.logError(Messages.bind("notify.lock.failed", info.getPath()));
                } else {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 24: {
                if (info.getErrMsg() == null) {
                    this.logError(Messages.bind("notify.unlock.failed", info.getPath()));
                } else {
                    this.logError(info.getErrMsg());
                }
                notify = false;
                break;
            }
            case 21: {
                if (info.getLock() != null && info.getLock().getOwner() != null) {
                    this.logMessage(Messages.bind("notify.lock.other", info.getLock().getPath(), info.getLock().getOwner()));
                } else {
                    this.logMessage(Messages.bind("notify.lock", info.getPath()));
                }
                notify = false;
                break;
            }
            case 22: {
                this.logMessage(Messages.bind("notify.unlock", info.getPath()));
                notify = false;
                break;
            }
            case 8: {
                this.logMessage("D   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.deletes;
                break;
            }
            case 30: {
                this.logMessage("R   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                ++this.deletes;
                break;
            }
            case 9: {
                this.logMessage("A   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.adds;
                break;
            }
            case 25: {
                this.logMessage("E   " + info.getPath());
                this.receivedSomeChange = true;
                ++this.exists;
                break;
            }
            case 3: {
                this.logMessage(Messages.bind("notify.restored", info.getPath()));
                break;
            }
            case 4: {
                this.logMessage(Messages.bind("notify.reverted", info.getPath()));
                break;
            }
            case 5: {
                this.logError(Messages.bind("notify.revert.failed", info.getPath()));
                notify = false;
                break;
            }
            case 6: {
                this.logMessage(Messages.bind("notify.resolved", info.getPath()));
                break;
            }
            case 0: {
                this.logMessage("A         " + info.getPath());
                break;
            }
            case 2: {
                this.logMessage("D         " + info.getPath());
                this.receivedSomeChange = true;
                break;
            }
            case 38: {
                this.logError("  C " + info.getPath());
                this.receivedSomeChange = true;
                ++this.treeConflicts;
                break;
            }
            case 10: {
                boolean error = false;
                if (info.getKind() == 2 && (info.getPropState() == 0 || info.getPropState() == 1 || info.getPropState() == 2)) break;
                this.receivedSomeChange = true;
                char[] statecharBuf = new char[]{' ', ' '};
                if (info.getKind() == 1) {
                    if (info.getContentState() == 7) {
                        statecharBuf[0] = 67;
                        ++this.conflicts;
                        error = true;
                    } else if (info.getContentState() == 6) {
                        statecharBuf[0] = 71;
                        ++this.merges;
                        error = true;
                    } else if (info.getContentState() == 5) {
                        statecharBuf[0] = 85;
                        ++this.updates;
                    } else if (info.getContentState() == 2 && info.getPropState() < 4) break;
                }
                if (info.getPropState() == 7) {
                    statecharBuf[1] = 67;
                    ++this.propConflicts;
                    error = true;
                } else if (info.getPropState() == 6) {
                    statecharBuf[1] = 71;
                    ++this.propMerges;
                    error = true;
                } else if (info.getPropState() == 5) {
                    statecharBuf[1] = 85;
                    ++this.propUpdates;
                }
                if (info.getContentState() == 1 && info.getPropState() == 1) break;
                if (error) {
                    this.logError("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                    break;
                }
                this.logMessage("" + statecharBuf[0] + statecharBuf[1] + "  " + info.getPath());
                break;
            }
            case 12: {
                this.logMessage(Messages.bind("notify.update.external", info.getPath()));
                this.inExternal = true;
                break;
            }
            case 11: {
                notify = false;
                if (info.getRevision() >= 0L) {
                    this.logRevision(info.getRevision(), info.getPath());
                    if (this.command == 8) {
                        this.logCompleted(Messages.bind("notify.export", Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.command == 2) {
                        this.logCompleted(Messages.bind("notify.checkout", Long.toString(info.getRevision())));
                        break;
                    }
                    if (this.receivedSomeChange) {
                        if (this.holdStats) {
                            if (this.inExternal) {
                                this.lastExternalUpdate = Messages.bind("notify.update", Long.toString(info.getRevision()));
                                break;
                            }
                            this.lastUpdate = Messages.bind("notify.update", Long.toString(info.getRevision()));
                            break;
                        }
                        this.logCompleted(Messages.bind("notify.update", Long.toString(info.getRevision())));
                        break;
                    }
                    this.logCompleted(Messages.bind("notify.at", Long.toString(info.getRevision())));
                    break;
                }
                if (this.command == 8) {
                    this.logCompleted(Messages.bind("notify.export.complete"));
                    break;
                }
                if (this.command == 2) {
                    this.logCompleted(Messages.bind("notify.checkout.complete"));
                    break;
                }
                this.logCompleted(Messages.bind("notify.update.complete"));
                break;
            }
            case 14: {
                if (!this.skipCommand()) {
                    this.logMessage(Messages.bind("notify.status.external", info.getPath()));
                }
                notify = false;
                break;
            }
            case 13: {
                notify = false;
                if (info.getRevision() < 0L) break;
                this.logRevision(info.getRevision(), info.getPath());
                if (this.skipCommand()) break;
                this.logMessage(Messages.bind("notify.status.revision", Long.toString(info.getRevision())));
                break;
            }
            case 15: {
                this.logMessage(Messages.bind("notify.commit.modified", info.getPath()));
                break;
            }
            case 16: {
                this.logMessage(Messages.bind("notify.commit.add", info.getPath()));
                break;
            }
            case 17: {
                this.logMessage(Messages.bind("notify.commit.delete", info.getPath()));
                break;
            }
            case 18: {
                this.logMessage(Messages.bind("notify.commit.replace", info.getPath()));
                break;
            }
            case 19: {
                notify = false;
                if (this.sentFirstTxdelta) break;
                this.logMessage(Messages.bind("notify.commit.transmit"));
                this.sentFirstTxdelta = true;
                break;
            }
            case -11: {
                notify = false;
                this.logCompleted(Messages.bind("notify.commit", Long.toString(info.getRevision())));
                break;
            }
            case 31: {
                this.logMessage(Messages.bind("notify.property.set", info.getPath()));
                break;
            }
            case 32: {
                this.logMessage(Messages.bind("notify.property.set", info.getPath()));
                break;
            }
            case 33: {
                this.logMessage(Messages.bind("notify.property.deleted", info.getPath()));
                break;
            }
            case 34: {
                notify = false;
                this.logMessage(Messages.bind("notify.property.deleted.nonexistent"));
                break;
            }
            case 35: {
                notify = false;
                this.logMessage(Messages.bind("notify.revision.property.set"));
                break;
            }
            case 36: {
                notify = false;
                this.logMessage(Messages.bind("notify.revision.property.deleted"));
                break;
            }
            case 37: {
                break;
            }
            case 20: {
                break;
            }
            default: {
                this.logMessage("Unknown action received: " + info.getAction());
            }
        }
        if (notify) {
            this.notifyListenersOfChange(info.getPath(), JhlConverter.convertNodeKind(info.getKind()));
        }
    }

    public void setCommand(int command) {
        this.receivedSomeChange = false;
        this.sentFirstTxdelta = false;
        if (command == 4 || command == 27 || command == 26) {
            this.clearStats();
            this.statsCommand = true;
        }
        super.setCommand(command);
    }

    public void logCompleted(String message) {
        super.logCompleted(message);
        if (this.inExternal) {
            this.inExternal = false;
        } else {
            this.logStats();
        }
    }

    private void clearStats() {
        this.adds = 0;
        this.updates = 0;
        this.deletes = 0;
        this.conflicts = 0;
        this.merges = 0;
        this.exists = 0;
        this.propConflicts = 0;
        this.treeConflicts = 0;
        this.propMerges = 0;
        this.propUpdates = 0;
        this.inExternal = false;
        this.holdStats = false;
        this.lastUpdate = null;
        this.lastExternalUpdate = null;
    }

    private void logStats() {
        if (this.holdStats) {
            return;
        }
        if (this.statsCommand) {
            if (this.fileStats()) {
                this.logMessage(Messages.bind("notify.stats.file.head"));
                if (this.merges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.merges)));
                }
                if (this.deletes > 0) {
                    this.logMessage(Messages.bind("notify.stats.delete", Integer.toString(this.deletes)));
                }
                if (this.adds > 0) {
                    this.logMessage(Messages.bind("notify.stats.add", Integer.toString(this.adds)));
                }
                if (this.updates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.updates)));
                }
                if (this.exists > 0) {
                    this.logMessage(Messages.bind("notify.stats.exists", Integer.toString(this.exists)));
                }
            }
            if (this.propStats()) {
                this.logMessage(Messages.bind("notify.stats.prop.head"));
                if (this.propMerges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.propMerges)));
                }
                if (this.propUpdates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.propUpdates)));
                }
            }
            if (this.conflictStats()) {
                this.logMessage(Messages.bind("notify.stats.conflict.head"));
                if (this.conflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.conflict", Integer.toString(this.conflicts)));
                }
                if (this.propConflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.prop.conflicts", Integer.toString(this.propConflicts)));
                }
                if (this.treeConflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.tree.conflicts", Integer.toString(this.treeConflicts)));
                }
            }
            this.statsCommand = false;
            this.clearStats();
        }
    }

    private boolean fileStats() {
        return this.updates > 0 || this.adds > 0 || this.deletes > 0 || this.merges > 0 || this.exists > 0;
    }

    private boolean conflictStats() {
        return this.treeConflicts > 0 || this.propConflicts > 0 || this.conflicts > 0;
    }

    private boolean propStats() {
        return this.propUpdates > 0 || this.propMerges > 0;
    }

    public void holdStats() {
        this.holdStats = true;
    }

    public void releaseStats() {
        this.holdStats = false;
        if (this.command == 4) {
            if (this.lastExternalUpdate != null) {
                this.logCompleted(this.lastExternalUpdate);
            }
            if (this.lastUpdate != null) {
                this.logCompleted(this.lastUpdate);
            }
        }
        this.logStats();
    }
}

