/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffCallback
implements ISvnDiffCallback {
    private ISvnDiffGenerator generator;
    private OutputStream outputStream;
    private long revision2;
    private long revision1;
    private boolean noCopyFromOnAdd;
    private boolean diffTargetIsCopy;

    public SvnDiffCallback(ISvnDiffGenerator generator, long rev1, long rev2, boolean noCopyFromOnAdd, boolean diffTargetIsCopy, OutputStream outputStream) {
        this.generator = generator;
        this.noCopyFromOnAdd = noCopyFromOnAdd;
        this.revision1 = rev1;
        this.revision2 = rev2;
        this.diffTargetIsCopy = diffTargetIsCopy;
        this.outputStream = outputStream;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
    }

    @Override
    public void fileChanged(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        if (leftFile != null) {
            this.displayContentChanged(path, leftFile, rightFile, rev1, rev2, mimeType1, mimeType2, propChanges, originalProperties, OperationKind.Modified, null);
        }
        if (propChanges != null && !propChanges.isEmpty()) {
            this.propertiesChanged(path, rev1, rev2, false, propChanges, originalProperties);
        }
    }

    @Override
    public void fileAdded(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, File copyFromPath, long copyFromRevision, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        this.generator.setForceEmpty(true);
        if (this.diffTargetIsCopy) {
            if (rev1 == -1L && this.revision1 != -1L) {
                rev1 = this.revision1;
            }
            if (rev2 == -1L && this.revision2 != -1L) {
                rev2 = this.revision2;
            }
        }
        if (this.noCopyFromOnAdd && (copyFromPath != null || SVNRevision.isValidRevisionNumber(copyFromRevision))) {
            SVNProperties newChanges = new SVNProperties(originalProperties);
            newChanges.putAll(propChanges);
            leftFile = null;
            propChanges = newChanges;
            originalProperties = new SVNProperties();
            copyFromRevision = -1L;
        }
        if (rightFile != null && copyFromPath != null) {
            this.displayContentChanged(path, leftFile, rightFile, rev1, rev2, mimeType1, mimeType2, propChanges, originalProperties, OperationKind.Copied, copyFromPath);
        } else if (rightFile != null) {
            this.displayContentChanged(path, leftFile, rightFile, rev1, rev2, mimeType1, mimeType2, propChanges, originalProperties, OperationKind.Added, null);
        }
        if (propChanges != null && !propChanges.isEmpty()) {
            this.propertiesChanged(path, rev1, rev2, false, propChanges, originalProperties);
        }
        this.generator.setForceEmpty(false);
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult result, File path, File leftFile, File rightFile, String mimeType1, String mimeType2, SVNProperties originalProperties) throws SVNException {
        this.displayContentChanged(path, leftFile, null, this.revision1, this.revision2, mimeType1, mimeType2, null, originalProperties, OperationKind.Deleted, null);
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult result, File path) throws SVNException {
        this.generator.displayDeletedDirectory(this.getTarget(path), this.getRevisionString(this.revision1), this.getRevisionString(this.revision2), this.outputStream);
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult result, File path, long revision) throws SVNException {
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult result, File path, long revision, String copyFromPath, long copyFromRevision) throws SVNException {
        this.generator.displayAddedDirectory(this.getTarget(path), this.getRevisionString(this.revision1), this.getRevisionString(revision), this.outputStream);
    }

    @Override
    public void dirPropsChanged(SvnDiffCallbackResult result, File path, boolean dirWasAdded, SVNProperties propChanges, SVNProperties originalProperties) throws SVNException {
        originalProperties = originalProperties == null ? new SVNProperties() : originalProperties;
        SVNProperties regularDiff = SvnDiffCallback.getRegularProperties(propChanges = propChanges == null ? new SVNProperties() : propChanges);
        if (regularDiff == null || regularDiff.isEmpty()) {
            return;
        }
        this.generator.displayPropsChanged(this.getTarget(path), dirWasAdded ? this.getRevisionString(0L) : this.getRevisionString(this.revision1), this.getRevisionString(this.revision2), dirWasAdded, originalProperties, regularDiff, this.outputStream);
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult result, File path, boolean dirWasAdded) throws SVNException {
    }

    private String getRevisionString(long revision) {
        if (revision >= 0L) {
            return "(revision " + revision + ")";
        }
        return "(working copy)";
    }

    private static SVNProperties getRegularProperties(SVNProperties propChanges) {
        if (propChanges == null) {
            return null;
        }
        SVNProperties regularPropertiesChanges = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(propChanges, regularPropertiesChanges, null, null);
        return regularPropertiesChanges;
    }

    public void propertiesChanged(File path, long revision1, long revision2, boolean dirWasAdded, SVNProperties diff, SVNProperties originalProperties) throws SVNException {
        originalProperties = originalProperties == null ? new SVNProperties() : originalProperties;
        SVNProperties regularDiff = SvnDiffCallback.getRegularProperties(diff = diff == null ? new SVNProperties() : diff);
        if (regularDiff != null && !regularDiff.isEmpty()) {
            this.generator.displayPropsChanged(this.getTarget(path), this.getRevisionString(revision1), this.getRevisionString(revision2), dirWasAdded, originalProperties, regularDiff, this.outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayContentChanged(File path, File leftFile, File rightFile, long rev1, long rev2, String mimeType1, String mimeType2, SVNProperties propChanges, SVNProperties originalProperties, OperationKind operation, File copyFromPath) throws SVNException {
        boolean resetEncoding = false;
        OutputStream result = this.outputStream;
        String encoding = this.defineEncoding(originalProperties, propChanges);
        if (encoding != null) {
            this.generator.setEncoding(encoding);
            resetEncoding = true;
        } else {
            String conversionEncoding = this.defineConversionEncoding(originalProperties, propChanges);
            if (conversionEncoding != null) {
                resetEncoding = this.adjustDiffGenerator("UTF-8");
                result = new SVNCharsetOutputStream(result, Charset.forName("UTF-8"), Charset.forName(conversionEncoding), CodingErrorAction.IGNORE, CodingErrorAction.IGNORE);
            }
        }
        try {
            this.generator.displayContentChanged(this.getTarget(path), leftFile, rightFile, this.getRevisionString(rev1), this.getRevisionString(rev2), mimeType1, mimeType2, operation, copyFromPath, result);
        }
        finally {
            if (resetEncoding) {
                this.generator.setEncoding(null);
                this.generator.setEOL(null);
            }
            if (result instanceof SVNCharsetOutputStream) {
                try {
                    result.flush();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), e, SVNLogType.WC);
                }
            }
        }
    }

    private String defineEncoding(SVNProperties properties, SVNProperties diff) {
        ISvnDiffGenerator defaultGenerator = this.generator;
        if (defaultGenerator.getEncoding() != null) {
            return null;
        }
        String originalEncoding = this.getCharsetByMimeType(properties, defaultGenerator);
        if (originalEncoding != null) {
            return originalEncoding;
        }
        String changedEncoding = this.getCharsetByMimeType(diff, defaultGenerator);
        if (changedEncoding != null) {
            return changedEncoding;
        }
        return null;
    }

    private String getCharsetByMimeType(SVNProperties properties, ISvnDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String mimeType = properties.getStringValue("svn:mime-type");
        String charset = SVNPropertiesManager.determineEncodingByMimeType(mimeType);
        return this.getCharset(charset, generator, false);
    }

    private String getCharset(SVNProperties properties, ISvnDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String charset = properties.getStringValue("svnkit:charset");
        return this.getCharset(charset, generator, true);
    }

    private String getCharset(String charset, ISvnDiffGenerator generator, boolean allowNative) {
        if (charset == null) {
            return null;
        }
        if (allowNative && "native".equals(charset)) {
            return generator.getEncoding();
        }
        if (Charset.isSupported(charset)) {
            return charset;
        }
        return null;
    }

    private String defineConversionEncoding(SVNProperties properties, SVNProperties diff) {
        ISvnDiffGenerator defaultGenerator = this.generator;
        if (defaultGenerator.getEncoding() != null) {
            return null;
        }
        String originalCharset = this.getCharset(properties, defaultGenerator);
        if (originalCharset != null) {
            return originalCharset;
        }
        String changedCharset = this.getCharset(diff, defaultGenerator);
        if (changedCharset != null) {
            return changedCharset;
        }
        String globalEncoding = this.getCharset(defaultGenerator.getGlobalEncoding(), defaultGenerator, false);
        if (globalEncoding != null) {
            return globalEncoding;
        }
        return null;
    }

    private boolean adjustDiffGenerator(String charset) {
        boolean encodingAdjusted = false;
        if (this.generator.getEncoding() == null) {
            this.generator.setEncoding(charset);
            encodingAdjusted = true;
        }
        if (this.generator.getEOL() == null) {
            byte[] eol;
            String eolString = System.getProperty("line.separator");
            try {
                eol = eolString.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                eol = eolString.getBytes();
            }
            this.generator.setEOL(eol);
        }
        return encodingAdjusted;
    }

    private SvnTarget getTarget(File path) {
        return SvnTarget.fromFile(path);
    }

    public static enum OperationKind {
        Unchanged,
        Added,
        Deleted,
        Copied,
        Moved,
        Modified;

    }
}

