/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.cache;

import java.util.List;
import java.util.Properties;
import org.thymeleaf.Template;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheManager
implements ICacheManager {
    private volatile ICache<String, Template> templateCache;
    private volatile boolean templateCacheInitialized = false;
    private volatile ICache<String, List<Node>> fragmentCache;
    private volatile boolean fragmentCacheInitialized = false;
    private volatile ICache<String, Object> expressionCache;
    private volatile boolean expressionCacheInitialized = false;
    private volatile ICache<String, Properties> messageCache;
    private volatile boolean messageCacheInitialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<String, Template> getTemplateCache() {
        if (!this.templateCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.templateCacheInitialized) {
                    this.templateCache = this.initializeTemplateCache();
                    this.templateCacheInitialized = true;
                }
            }
        }
        return this.templateCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<String, List<Node>> getFragmentCache() {
        if (!this.fragmentCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.fragmentCacheInitialized) {
                    this.fragmentCache = this.initializeFragmentCache();
                    this.fragmentCacheInitialized = true;
                }
            }
        }
        return this.fragmentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<String, Properties> getMessageCache() {
        if (!this.messageCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.messageCacheInitialized) {
                    this.messageCache = this.initializeMessageCache();
                    this.messageCacheInitialized = true;
                }
            }
        }
        return this.messageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICache<String, Object> getExpressionCache() {
        if (!this.expressionCacheInitialized) {
            AbstractCacheManager abstractCacheManager = this;
            synchronized (abstractCacheManager) {
                if (!this.expressionCacheInitialized) {
                    this.expressionCache = this.initializeExpressionCache();
                    this.expressionCacheInitialized = true;
                }
            }
        }
        return this.expressionCache;
    }

    @Override
    public <K, V> ICache<K, V> getSpecificCache(String name) {
        return null;
    }

    protected abstract ICache<String, Template> initializeTemplateCache();

    protected abstract ICache<String, List<Node>> initializeFragmentCache();

    protected abstract ICache<String, Properties> initializeMessageCache();

    protected abstract ICache<String, Object> initializeExpressionCache();
}

