/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.AbstractProcessingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IExpressionEnhancingDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDialectAwareProcessingContext
extends AbstractProcessingContext {
    private final Set<IExpressionEnhancingDialect> dialects;

    public AbstractDialectAwareProcessingContext(IContext context, Collection<? extends IDialect> dialects) {
        super(context);
        this.dialects = AbstractDialectAwareProcessingContext.selectEnhancingDialects(dialects);
    }

    public AbstractDialectAwareProcessingContext(IContext context, Map<String, Object> localVariables, Collection<? extends IDialect> dialects) {
        super(context, localVariables);
        this.dialects = AbstractDialectAwareProcessingContext.selectEnhancingDialects(dialects);
    }

    public AbstractDialectAwareProcessingContext(IContext context, Map<String, Object> localVariables, Object selectionTarget, boolean selectionTargetSet, Collection<? extends IDialect> dialects) {
        super(context, localVariables, selectionTarget, selectionTargetSet);
        this.dialects = AbstractDialectAwareProcessingContext.selectEnhancingDialects(dialects);
    }

    protected Set<IExpressionEnhancingDialect> getExpressionEnhancingDialects() {
        return this.dialects;
    }

    private static Set<IExpressionEnhancingDialect> selectEnhancingDialects(Collection<? extends IDialect> dialects) {
        if (dialects == null || dialects.size() == 0) {
            return null;
        }
        HashSet<IExpressionEnhancingDialect> enhancingDialects = null;
        for (IDialect iDialect : dialects) {
            if (!(iDialect instanceof IExpressionEnhancingDialect)) continue;
            if (enhancingDialects == null) {
                enhancingDialects = new HashSet<IExpressionEnhancingDialect>(4, 1.0f);
            }
            enhancingDialects.add((IExpressionEnhancingDialect)iDialect);
        }
        return enhancingDialects;
    }

    @Override
    protected Map<String, Object> computeExpressionObjects() {
        if (this.dialects == null) {
            return super.computeExpressionObjects();
        }
        HashMap<String, Object> variables = new HashMap<String, Object>(super.computeExpressionObjects());
        for (IExpressionEnhancingDialect dialect : this.dialects) {
            Map<String, Object> dialectVariables = dialect.getAdditionalExpressionObjects(this);
            if (dialectVariables == null) continue;
            variables.putAll(dialectVariables);
        }
        return variables;
    }
}

