/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.NumberPointType;
import org.thymeleaf.util.NumberUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Numbers {
    public String formatInteger(Number target, Integer minIntegerDigits) {
        try {
            return NumberUtils.format(target, minIntegerDigits, Numbers.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting integer with minimum integer digits = " + minIntegerDigits, e);
        }
    }

    public String[] arrayFormatInteger(Object[] target, Integer minIntegerDigits) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatInteger((Number)target[i], minIntegerDigits);
        }
        return result;
    }

    public List<String> listFormatInteger(List<? extends Number> target, Integer minIntegerDigits) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Number number : target) {
            result.add(this.formatInteger(number, minIntegerDigits));
        }
        return result;
    }

    public Set<String> setFormatInteger(Set<? extends Number> target, Integer minIntegerDigits) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Number number : target) {
            result.add(this.formatInteger(number, minIntegerDigits));
        }
        return result;
    }

    public String formatInteger(Number target, Integer minIntegerDigits, String thousandsPointType) {
        NumberPointType thousandsNumberPointType = NumberPointType.match(thousandsPointType);
        if (thousandsNumberPointType == null) {
            throw new TemplateProcessingException("Unrecognized point format \"" + thousandsPointType + "\"");
        }
        try {
            return NumberUtils.format(target, minIntegerDigits, thousandsNumberPointType, Numbers.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting integer with minimum integer digits = " + minIntegerDigits + " and thousands point type = " + thousandsPointType, e);
        }
    }

    public String[] arrayFormatInteger(Object[] target, Integer minIntegerDigits, String thousandsPointType) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatInteger((Number)target[i], minIntegerDigits, thousandsPointType);
        }
        return result;
    }

    public List<String> listFormatInteger(List<? extends Number> target, Integer minIntegerDigits, String thousandsPointType) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Number number : target) {
            result.add(this.formatInteger(number, minIntegerDigits, thousandsPointType));
        }
        return result;
    }

    public Set<String> setFormatInteger(Set<? extends Number> target, Integer minIntegerDigits, String thousandsPointType) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Number number : target) {
            result.add(this.formatInteger(number, minIntegerDigits, thousandsPointType));
        }
        return result;
    }

    public String formatDecimal(Number target, Integer minIntegerDigits, Integer decimalDigits) {
        try {
            return NumberUtils.format(target, minIntegerDigits, decimalDigits, Numbers.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting decimal with minimum integer digits = " + minIntegerDigits + " and decimal digits " + decimalDigits, e);
        }
    }

    public String[] arrayFormatDecimal(Object[] target, Integer minIntegerDigits, Integer decimalDigits) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatDecimal((Number)target[i], minIntegerDigits, decimalDigits);
        }
        return result;
    }

    public List<String> listFormatDecimal(List<? extends Number> target, Integer minIntegerDigits, Integer decimalDigits) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, decimalDigits));
        }
        return result;
    }

    public Set<String> setFormatDecimal(Set<? extends Number> target, Integer minIntegerDigits, Integer decimalDigits) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, decimalDigits));
        }
        return result;
    }

    public String formatDecimal(Number target, Integer minIntegerDigits, Integer decimalDigits, String decimalPointType) {
        NumberPointType decimalNumberPointType = NumberPointType.match(decimalPointType);
        if (decimalNumberPointType == null) {
            throw new TemplateProcessingException("Unrecognized point format \"" + decimalPointType + "\"");
        }
        try {
            return NumberUtils.format(target, minIntegerDigits, decimalDigits, decimalNumberPointType, Numbers.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting decimal with minimum integer digits = " + minIntegerDigits + ", decimal digits = " + decimalDigits + " and decimal point type = " + decimalPointType, e);
        }
    }

    public String[] arrayFormatDecimal(Object[] target, Integer minIntegerDigits, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatDecimal((Number)target[i], minIntegerDigits, decimalDigits, decimalPointType);
        }
        return result;
    }

    public List<String> listFormatDecimal(List<? extends Number> target, Integer minIntegerDigits, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, decimalDigits, decimalPointType));
        }
        return result;
    }

    public Set<String> setFormatDecimal(Set<? extends Number> target, Integer minIntegerDigits, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, decimalDigits, decimalPointType));
        }
        return result;
    }

    public String formatDecimal(Number target, Integer minIntegerDigits, String thousandsPointType, Integer decimalDigits, String decimalPointType) {
        NumberPointType decimalNumberPointType = NumberPointType.match(decimalPointType);
        if (decimalNumberPointType == null) {
            throw new TemplateProcessingException("Unrecognized point format \"" + decimalPointType + "\"");
        }
        NumberPointType thousandsNumberPointType = NumberPointType.match(thousandsPointType);
        if (thousandsNumberPointType == null) {
            throw new TemplateProcessingException("Unrecognized point format \"" + thousandsPointType + "\"");
        }
        try {
            return NumberUtils.format(target, minIntegerDigits, thousandsNumberPointType, decimalDigits, decimalNumberPointType, Numbers.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting decimal with minimum integer digits = " + minIntegerDigits + ", thousands point type = " + thousandsPointType + ", decimal digits = " + decimalDigits + " and decimal point type = " + decimalPointType, e);
        }
    }

    public String[] arrayFormatDecimal(Object[] target, Integer minIntegerDigits, String thousandsPointType, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatDecimal((Number)target[i], minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType);
        }
        return result;
    }

    public List<String> listFormatDecimal(List<? extends Number> target, Integer minIntegerDigits, String thousandsPointType, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType));
        }
        return result;
    }

    public Set<String> setFormatDecimal(Set<? extends Number> target, Integer minIntegerDigits, String thousandsPointType, Integer decimalDigits, String decimalPointType) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Number number : target) {
            result.add(this.formatDecimal(number, minIntegerDigits, thousandsPointType, decimalDigits, decimalPointType));
        }
        return result;
    }

    public Integer[] sequence(Integer from, Integer to) {
        return NumberUtils.sequence(from, to);
    }

    public Integer[] sequence(Integer from, Integer to, Integer step) {
        return NumberUtils.sequence(from, to, step);
    }

    private static Locale getLocale() {
        Locale locale = TemplateEngine.threadLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

