/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractChildrenModifierAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnescapedTextChildModifierAttrProcessor
extends AbstractChildrenModifierAttrProcessor {
    public AbstractUnescapedTextChildModifierAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public AbstractUnescapedTextChildModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final List<Node> getModifiedChildren(Arguments arguments, Element element, String attributeName) {
        String text = this.getText(arguments, element, attributeName);
        try {
            TemplateRepository templateRepository = arguments.getTemplateRepository();
            List<Node> fragNodes = templateRepository.getFragment(arguments, text);
            for (Node node : fragNodes) {
                node.setSkippable(true);
            }
            return fragNodes;
        }
        catch (TemplateEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("An error happened during parsing of unescaped text: \"" + element.getAttributeValue(attributeName) + "\"", e);
        }
    }

    protected abstract String getText(Arguments var1, Element var2, String var3);
}

