/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.MultiplicationDivisionRemainderExpression;
import org.thymeleaf.util.ObjectUtils;

public final class DivisionExpression
extends MultiplicationDivisionRemainderExpression {
    private static final long serialVersionUID = -6480768503994179971L;
    private static final Logger logger = LoggerFactory.getLogger(DivisionExpression.class);

    public DivisionExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("/");
    }

    static Object executeDivision(Configuration configuration, IProcessingContext processingContext, DivisionExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating division expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(configuration, processingContext, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(configuration, processingContext, expression.getRight(), expressionEvaluator);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            return leftNumberValue.divide(rightNumberValue);
        }
        throw new TemplateProcessingException("Cannot execute division: operands are \"" + LiteralValue.unwrap(leftValue) + "\" and \"" + LiteralValue.unwrap(rightValue) + "\"");
    }
}

