/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.StandardExpressionExecutor;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

public final class StandardExpressionParser {
    private final StandardExpressionExecutor executor;
    private static final char PREPROCESS_DELIMITER = '_';
    private static final String PREPROCESS_EVAL = "\\_\\_(.*?)\\_\\_";
    private static final Pattern PREPROCESS_EVAL_PATTERN = Pattern.compile("\\_\\_(.*?)\\_\\_", 32);
    private static final ExpressionCache CACHE = new ExpressionCache();

    StandardExpressionParser(StandardExpressionExecutor executor) {
        this.executor = executor;
    }

    public Expression parseExpression(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpression(arguments.getConfiguration(), arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public Expression parseExpression(Configuration configuration, IProcessingContext processingContext, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Evaluation Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpression(configuration, processingContext, DOMUtils.unescapeXml(input, true), true);
    }

    public AssignationSequence parseAssignationSequence(Arguments arguments, String input, boolean allowParametersWithoutValue) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseAssignationSequence(arguments.getConfiguration(), arguments, DOMUtils.unescapeXml(input, true), true, allowParametersWithoutValue);
    }

    public AssignationSequence parseAssignationSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean allowParametersWithoutValue) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Evaluation Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseAssignationSequence(configuration, processingContext, DOMUtils.unescapeXml(input, true), true, allowParametersWithoutValue);
    }

    public ExpressionSequence parseExpressionSequence(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpressionSequence(arguments.getConfiguration(), arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public ExpressionSequence parseExpressionSequence(Configuration configuration, IProcessingContext processingContext, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Evaluation Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseExpressionSequence(configuration, processingContext, DOMUtils.unescapeXml(input, true), true);
    }

    public Each parseEach(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseEach(arguments.getConfiguration(), arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public Each parseEach(Configuration configuration, IProcessingContext processingContext, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Evaluation Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseEach(configuration, processingContext, DOMUtils.unescapeXml(input, true), true);
    }

    public FragmentSelection parseFragmentSelection(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseFragmentSelection(arguments.getConfiguration(), arguments, DOMUtils.unescapeXml(input, true), true);
    }

    public FragmentSelection parseFragmentSelection(Configuration configuration, IProcessingContext processingContext, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Evaluation Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return this.parseFragmentSelection(configuration, processingContext, DOMUtils.unescapeXml(input, true), true);
    }

    Expression parseExpression(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess) {
        Expression cachedExpression;
        String preprocessedInput;
        String trimmedInput = input.trim();
        String string = preprocessedInput = preprocess ? this.preprocess(configuration, processingContext, trimmedInput) : trimmedInput;
        if (configuration != null && (cachedExpression = CACHE.getExpressionFromCache(configuration, preprocessedInput)) != null) {
            return cachedExpression;
        }
        Expression expression = Expression.parse(preprocessedInput);
        if (expression == null) {
            throw new TemplateProcessingException("Could not parse as expression: \"" + input + "\"");
        }
        if (configuration != null) {
            CACHE.putExpressionIntoCache(configuration, preprocessedInput, expression);
        }
        return expression;
    }

    AssignationSequence parseAssignationSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess, boolean allowParametersWithoutValue) {
        AssignationSequence cachedAssignationSequence;
        String preprocessedInput;
        String trimmedInput = input.trim();
        String string = preprocessedInput = preprocess ? this.preprocess(configuration, processingContext, trimmedInput) : trimmedInput;
        if (configuration != null && (cachedAssignationSequence = CACHE.getAssignationSequenceFromCache(configuration, preprocessedInput)) != null) {
            return cachedAssignationSequence;
        }
        AssignationSequence assignationSequence = AssignationSequence.parse(preprocessedInput, allowParametersWithoutValue);
        if (assignationSequence == null) {
            throw new TemplateProcessingException("Could not parse as assignation sequence: \"" + input + "\"");
        }
        if (configuration != null) {
            CACHE.putAssignationSequenceIntoCache(configuration, preprocessedInput, assignationSequence);
        }
        return assignationSequence;
    }

    ExpressionSequence parseExpressionSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess) {
        ExpressionSequence cachedExpressionSequence;
        String preprocessedInput;
        String trimmedInput = input.trim();
        String string = preprocessedInput = preprocess ? this.preprocess(configuration, processingContext, trimmedInput) : trimmedInput;
        if (configuration != null && (cachedExpressionSequence = CACHE.getExpressionSequenceFromCache(configuration, preprocessedInput)) != null) {
            return cachedExpressionSequence;
        }
        ExpressionSequence expressionSequence = ExpressionSequence.parse(preprocessedInput);
        if (expressionSequence == null) {
            throw new TemplateProcessingException("Could not parse as expression sequence: \"" + input + "\"");
        }
        if (configuration != null) {
            CACHE.putExpressionSequenceIntoCache(configuration, preprocessedInput, expressionSequence);
        }
        return expressionSequence;
    }

    Each parseEach(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess) {
        Each cachedEach;
        String preprocessedInput;
        String trimmedInput = input.trim();
        String string = preprocessedInput = preprocess ? this.preprocess(configuration, processingContext, trimmedInput) : trimmedInput;
        if (configuration != null && (cachedEach = CACHE.getEachFromCache(configuration, preprocessedInput)) != null) {
            return cachedEach;
        }
        Each each = Each.parse(preprocessedInput);
        if (each == null) {
            throw new TemplateProcessingException("Could not parse as each: \"" + input + "\"");
        }
        if (configuration != null) {
            CACHE.putEachIntoCache(configuration, preprocessedInput, each);
        }
        return each;
    }

    FragmentSelection parseFragmentSelection(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess) {
        FragmentSelection cachedFragmentSelection;
        String preprocessedInput;
        String trimmedInput = input.trim();
        String string = preprocessedInput = preprocess ? this.preprocess(configuration, processingContext, trimmedInput) : trimmedInput;
        if (configuration != null && (cachedFragmentSelection = CACHE.getFragmentSelectionFromCache(configuration, preprocessedInput)) != null) {
            return cachedFragmentSelection;
        }
        FragmentSelection fragmentSelection = FragmentSelection.parse(preprocessedInput);
        if (fragmentSelection == null) {
            throw new TemplateProcessingException("Could not parse as fragment selection: \"" + input + "\"");
        }
        if (configuration != null) {
            CACHE.putFragmentSelectionIntoCache(configuration, preprocessedInput, fragmentSelection);
        }
        return fragmentSelection;
    }

    String preprocess(Configuration configuration, IProcessingContext processingContext, String input) {
        if (input.indexOf(95) == -1) {
            return input;
        }
        Matcher matcher = PREPROCESS_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                Expression expression = this.parseExpression(configuration, processingContext, matcher.group(1), false);
                if (expression == null) {
                    return null;
                }
                Object result = this.executor.executeExpression(configuration, processingContext, expression);
                strBuilder.append(result);
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString().trim();
        }
        return input;
    }

    public String toString() {
        return "Standard Expression Parser";
    }
}

