/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.html;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateparser.EntityResolver;
import org.thymeleaf.templateparser.ErrorHandler;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.templateparser.TemplatePreprocessingReader;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.ResourcePool;
import org.thymeleaf.util.StandardDOMTranslator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHtmlTemplateParser
implements ITemplateParser {
    private final String templateModeName;
    private final boolean nekoInClasspath;
    private final NekoBasedHtmlParser parser;

    public AbstractHtmlTemplateParser(String templateModeName, int poolSize) {
        boolean nekoFound = true;
        try {
            ClassLoaderUtils.getClassLoader(AbstractHtmlTemplateParser.class).loadClass("org.cyberneko.html.parsers.DOMParser");
        }
        catch (ClassNotFoundException e) {
            nekoFound = false;
        }
        catch (NoClassDefFoundError e) {
            nekoFound = false;
        }
        this.nekoInClasspath = nekoFound;
        this.templateModeName = templateModeName;
        this.parser = this.nekoInClasspath ? new NekoBasedHtmlParser(poolSize) : null;
    }

    @Override
    public final Document parseTemplate(Configuration configuration, String documentName, Reader reader) {
        if (!this.nekoInClasspath) {
            throw new ConfigurationException("Cannot perform conversion to XML from legacy HTML: The nekoHTML library is not in classpath. nekoHTML 1.9.15 or newer is required for processing templates in \"" + this.templateModeName + "\" mode [http://nekohtml.sourceforge.net]. Maven spec: " + "\"net.sourceforge.nekohtml::nekohtml::1.9.15\". IMPORTANT: DO NOT use versions of " + "nekoHTML older than 1.9.15.");
        }
        return this.parser.parseTemplate(configuration, documentName, this.getTemplatePreprocessingReader(reader));
    }

    @Override
    public final List<Node> parseFragment(Configuration configuration, String fragment) {
        String wrappedFragment = this.wrapFragment(fragment);
        Document document = this.parseTemplate(configuration, null, new StringReader(wrappedFragment));
        return this.unwrapFragment(document);
    }

    protected abstract String wrapFragment(String var1);

    protected abstract List<Node> unwrapFragment(Document var1);

    protected boolean shouldAddThymeleafRootToParser() {
        return false;
    }

    protected TemplatePreprocessingReader getTemplatePreprocessingReader(Reader reader) {
        if (reader instanceof TemplatePreprocessingReader) {
            TemplatePreprocessingReader templatePreprocessingReader = (TemplatePreprocessingReader)reader;
            return new TemplatePreprocessingReader(templatePreprocessingReader.getInnerReader(), 8192, this.shouldAddThymeleafRootToParser());
        }
        return new TemplatePreprocessingReader(reader, 8192, this.shouldAddThymeleafRootToParser());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HtmlTemplateParserFactory
    implements ResourcePool.IResourceFactory<Object> {
        @Override
        public Object createResource() {
            try {
                HTMLConfiguration config = new HTMLConfiguration();
                config.setFeature("http://xml.org/sax/features/namespaces", false);
                config.setFeature("http://cyberneko.org/html/features/override-doctype", true);
                config.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
                config.setProperty("http://cyberneko.org/html/properties/doctype/pubid", (Object)"");
                config.setProperty("http://cyberneko.org/html/properties/doctype/sysid", (Object)"");
                config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
                return new DOMParser((XMLParserConfiguration)config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error while creating nekoHTML-based parser for LEGACYHTML5 template modes.", e);
            }
        }
    }

    private static class NekoBasedHtmlParser {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private ResourcePool<Object> pool;
        private boolean canResetParsers = true;

        public NekoBasedHtmlParser(int poolSize) {
            this.pool = new ResourcePool<Object>(new HtmlTemplateParserFactory(), poolSize);
        }

        public final Document parseTemplate(Configuration configuration, String documentName, TemplatePreprocessingReader templateReader) {
            DOMParser domParser = (DOMParser)this.pool.allocate();
            try {
                domParser.setErrorHandler((org.xml.sax.ErrorHandler)ErrorHandler.INSTANCE);
                domParser.setEntityResolver((org.xml.sax.EntityResolver)new EntityResolver(configuration));
                domParser.parse(new InputSource(templateReader));
                org.w3c.dom.Document domDocument = domParser.getDocument();
                if (this.canResetParsers) {
                    try {
                        domParser.reset();
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("[THYMELEAF] The HTML Parser implementation being used (\"{}\") does not implement the \"reset\" operation. This will force Thymeleaf to re-create parser instances each time they are needed for parsing templates, which is more costly. Enabling template cache is recommended, and also using a parser library which implements \"reset\" such as nekoHTML version 1.9.15 or newer.", (Object)domParser.getClass().getName());
                        }
                        this.canResetParsers = false;
                    }
                }
                Document document = StandardDOMTranslator.translateDocument(domDocument, documentName, templateReader.getDocTypeClause());
                return document;
            }
            catch (TemplateProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateInputException("Exception parsing document", e);
            }
            finally {
                if (this.canResetParsers) {
                    this.pool.release(domParser);
                } else {
                    this.pool.discardAndReplace(domParser);
                }
            }
        }
    }
}

