/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templateresolver.ITemplateResolutionValidity;
import org.thymeleaf.util.Validate;

public final class TemplateResolution {
    private final String templateName;
    private final String resourceName;
    private final IResourceResolver resourceResolver;
    private final String characterEncoding;
    private final String templateMode;
    private final ITemplateResolutionValidity validity;

    public TemplateResolution(String templateName, String resourceName, IResourceResolver resourceResolver, String characterEncoding, String templateMode, ITemplateResolutionValidity validity) {
        Validate.notNull(templateName, "Template name cannot be null");
        Validate.notNull(resourceName, "Resource name cannot be null");
        Validate.notNull(resourceResolver, "Resource resolver cannot be null");
        Validate.notNull(templateMode, "Template mode cannot be null");
        Validate.notNull(validity, "Validity cannot be null");
        this.templateName = templateName;
        this.resourceName = resourceName;
        this.resourceResolver = resourceResolver;
        this.characterEncoding = characterEncoding;
        this.templateMode = templateMode;
        this.validity = validity;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public IResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getTemplateMode() {
        return this.templateMode;
    }

    public ITemplateResolutionValidity getValidity() {
        return this.validity;
    }
}

