/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.util.PatternUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternSpec {
    private final LinkedHashSet<String> patternStrs = new LinkedHashSet();
    private final LinkedHashSet<Pattern> patterns = new LinkedHashSet();
    private volatile boolean initialized;

    protected final boolean isInitialized() {
        return this.initialized;
    }

    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            this.initialized = true;
        }
    }

    protected final void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template resolver when it has already been initialized");
        }
    }

    public final Set<String> getPatterns() {
        return Collections.unmodifiableSet(this.patternStrs);
    }

    public final void setPatterns(Set<String> newPatterns) {
        this.checkNotInitialized();
        if (newPatterns != null) {
            this.patternStrs.addAll(newPatterns);
            for (String pattern : newPatterns) {
                this.patterns.add(PatternUtils.strPatternToPattern(pattern));
            }
        }
    }

    public final void addPattern(String pattern) {
        this.checkNotInitialized();
        Validate.notEmpty(pattern, "Pattern cannot be null or empty");
        this.patternStrs.add(pattern);
        this.patterns.add(PatternUtils.strPatternToPattern(pattern));
    }

    public final void clearPatterns() {
        this.checkNotInitialized();
        this.patternStrs.clear();
        this.patterns.clear();
    }

    public boolean matches(String templateName) {
        for (Pattern p : this.patterns) {
            if (!p.matcher(templateName).matches()) continue;
            return true;
        }
        return false;
    }
}

