/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.exceptions;

import org.thymeleaf.exceptions.TemplateEngineException;

public class TemplateProcessingException
extends TemplateEngineException {
    private static final long serialVersionUID = 5985749439214775193L;
    private String templateName;
    private Integer lineNumber;

    public TemplateProcessingException(String message) {
        this(message, (String)null, (Integer)null);
    }

    public TemplateProcessingException(String message, Throwable cause) {
        this(message, (String)null, null, cause);
    }

    public TemplateProcessingException(String message, String templateName) {
        this(message, templateName, (Integer)null);
    }

    public TemplateProcessingException(String message, String templateName, Throwable cause) {
        this(message, templateName, null, cause);
    }

    public TemplateProcessingException(String message, String templateName, Integer lineNumber) {
        super(message);
        this.templateName = templateName;
        this.lineNumber = lineNumber;
    }

    public TemplateProcessingException(String message, String templateName, Integer lineNumber, Throwable cause) {
        super(message, cause);
        this.templateName = templateName;
        this.lineNumber = lineNumber;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean hasTemplateName() {
        return this.templateName != null;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public boolean hasLineNumber() {
        return this.lineNumber != null;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (this.templateName != null) {
            sb.append(" (");
            sb.append(this.templateName);
            if (this.lineNumber != null) {
                sb.append(":").append(this.lineNumber);
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

