/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bools {
    public Boolean isTrue(Object target) {
        return ObjectUtils.evaluateAsBoolean(target);
    }

    public Boolean[] arrayIsTrue(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.isTrue(target[i]);
        }
        return result;
    }

    public List<Boolean> listIsTrue(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.isTrue(element));
        }
        return result;
    }

    public Set<Boolean> setIsTrue(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.isTrue(element));
        }
        return result;
    }

    public Boolean isFalse(Object target) {
        return !ObjectUtils.evaluateAsBoolean(target);
    }

    public Boolean[] arrayIsFalse(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.isFalse(target[i]);
        }
        return result;
    }

    public List<Boolean> listIsFalse(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.isFalse(element));
        }
        return result;
    }

    public Set<Boolean> setIsFalse(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.isFalse(element));
        }
        return result;
    }

    public Boolean arrayAnd(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        for (int i = 0; i < target.length; ++i) {
            if (this.isTrue(target[i]).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean listAnd(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (this.isTrue(element).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean setAnd(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (this.isTrue(element).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean arrayOr(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        for (int i = 0; i < target.length; ++i) {
            if (!this.isTrue(target[i]).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean listOr(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (!this.isTrue(element).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean setOr(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        for (Object element : target) {
            if (!this.isTrue(element).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

