/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DateUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dates {
    public static Date create(Object year, Object month, Object day) {
        return DateUtils.create(year, month, day).getTime();
    }

    public static Date create(Object year, Object month, Object day, Object hour, Object minute) {
        return DateUtils.create(year, month, day, hour, minute).getTime();
    }

    public static Date create(Object year, Object month, Object day, Object hour, Object minute, Object second) {
        return DateUtils.create(year, month, day, hour, minute, second).getTime();
    }

    public static Date create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond).getTime();
    }

    public static Date createNow() {
        return DateUtils.createNow().getTime();
    }

    public static Date createToday() {
        return DateUtils.createToday().getTime();
    }

    public String format(Date target) {
        try {
            return DateUtils.format(target, Dates.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting date with standard format for locale " + Dates.getLocale(), e);
        }
    }

    public String[] arrayFormat(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Date)target[i]);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.format(date));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.format(date));
        }
        return result;
    }

    public String format(Date target, String pattern) {
        try {
            return DateUtils.format(target, pattern, Dates.getLocale());
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting date with format pattern \"" + pattern + "\"", e);
        }
    }

    public String[] arrayFormat(Object[] target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Date)target[i], pattern);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Date> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.format(date, pattern));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Date> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.format(date, pattern));
        }
        return result;
    }

    public Integer day(Date target) {
        return DateUtils.day(target);
    }

    public Integer[] arrayDay(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.day((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listDay(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.day(date));
        }
        return result;
    }

    public Set<Integer> setDay(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.day(date));
        }
        return result;
    }

    public Integer month(Date target) {
        return DateUtils.month(target);
    }

    public Integer[] arrayMonth(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.month((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listMonth(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.month(date));
        }
        return result;
    }

    public Set<Integer> setMonth(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.month(date));
        }
        return result;
    }

    public String monthName(Date target) {
        return DateUtils.monthName(target, Dates.getLocale());
    }

    public String[] arrayMonthName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthName((Date)target[i]);
        }
        return result;
    }

    public List<String> listMonthName(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.monthName(date));
        }
        return result;
    }

    public Set<String> setMonthName(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.monthName(date));
        }
        return result;
    }

    public String monthNameShort(Date target) {
        return DateUtils.monthNameShort(target, Dates.getLocale());
    }

    public String[] arrayMonthNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthNameShort((Date)target[i]);
        }
        return result;
    }

    public List<String> listMonthNameShort(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.monthNameShort(date));
        }
        return result;
    }

    public Set<String> setMonthNameShort(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.monthNameShort(date));
        }
        return result;
    }

    public Integer year(Date target) {
        return DateUtils.year(target);
    }

    public Integer[] arrayYear(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.year((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listYear(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.year(date));
        }
        return result;
    }

    public Set<Integer> setYear(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.year(date));
        }
        return result;
    }

    public Integer dayOfWeek(Date target) {
        return DateUtils.dayOfWeek(target);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeek((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listDayOfWeek(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.dayOfWeek(date));
        }
        return result;
    }

    public Set<Integer> setDayOfWeek(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.dayOfWeek(date));
        }
        return result;
    }

    public String dayOfWeekName(Date target) {
        return DateUtils.dayOfWeekName(target, Dates.getLocale());
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekName((Date)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekName(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.dayOfWeekName(date));
        }
        return result;
    }

    public Set<String> setDayOfWeekName(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.dayOfWeekName(date));
        }
        return result;
    }

    public String dayOfWeekNameShort(Date target) {
        return DateUtils.dayOfWeekNameShort(target, Dates.getLocale());
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekNameShort((Date)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekNameShort(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Date date : target) {
            result.add(this.dayOfWeekNameShort(date));
        }
        return result;
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Date date : target) {
            result.add(this.dayOfWeekNameShort(date));
        }
        return result;
    }

    public Integer hour(Date target) {
        return DateUtils.hour(target);
    }

    public Integer[] arrayHour(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.hour((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listHour(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.hour(date));
        }
        return result;
    }

    public Set<Integer> setHour(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.hour(date));
        }
        return result;
    }

    public Integer minute(Date target) {
        return DateUtils.minute(target);
    }

    public Integer[] arrayMinute(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.minute((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listMinute(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.minute(date));
        }
        return result;
    }

    public Set<Integer> setMinute(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.minute(date));
        }
        return result;
    }

    public Integer second(Date target) {
        return DateUtils.second(target);
    }

    public Integer[] arraySecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.second((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listSecond(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.second(date));
        }
        return result;
    }

    public Set<Integer> setSecond(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.second(date));
        }
        return result;
    }

    public Integer millisecond(Date target) {
        return DateUtils.millisecond(target);
    }

    public Integer[] arrayMillisecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.millisecond((Date)target[i]);
        }
        return result;
    }

    public List<Integer> listMillisecond(List<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Date date : target) {
            result.add(this.millisecond(date));
        }
        return result;
    }

    public Set<Integer> setMillisecond(Set<? extends Date> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Date date : target) {
            result.add(this.millisecond(date));
        }
        return result;
    }

    private static Locale getLocale() {
        Locale locale = TemplateEngine.threadLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

