/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DOMSelectorFragmentSpec
implements IFragmentSpec {
    public static final String DOM_SELECTOR_EXPRESSION_PREFIX = "{dom_selector}";
    private final String selectorExpression;
    private final boolean returnOnlyChildren;

    public DOMSelectorFragmentSpec(String selectorExpression) {
        this(selectorExpression, false);
    }

    public DOMSelectorFragmentSpec(String selectorExpression, boolean returnOnlyChildren) {
        Validate.notEmpty(selectorExpression, "DOM selector expression cannot be null or empty");
        this.selectorExpression = selectorExpression;
        this.returnOnlyChildren = returnOnlyChildren;
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    public boolean isReturnOnlyChildren() {
        return this.returnOnlyChildren;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> extraction;
        DOMSelector selector = null;
        ICache<String, Object> expressionCache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (expressionCache = cacheManager.getExpressionCache()) != null) {
            selector = (DOMSelector)expressionCache.get(DOM_SELECTOR_EXPRESSION_PREFIX + this.selectorExpression);
        }
        if (selector == null) {
            selector = new DOMSelector(this.selectorExpression);
            if (expressionCache != null) {
                expressionCache.put(DOM_SELECTOR_EXPRESSION_PREFIX + this.selectorExpression, selector);
            }
        }
        if ((extraction = selector.select(nodes)) == null || extraction.size() == 0) {
            return null;
        }
        if (!this.returnOnlyChildren) {
            return extraction;
        }
        ArrayList<Node> extractionChildren = new ArrayList<Node>();
        for (Node extractionNode : extraction) {
            if (extractionNode == null) continue;
            if (!(extractionNode instanceof NestableNode)) {
                throw new TemplateProcessingException("Cannot correctly retrieve children of node selected by fragment spec with DOM selector \"" + this.selectorExpression + "\". Node is not a " + "nestable node (" + extractionNode.getClass().getSimpleName() + ").");
            }
            extractionChildren.addAll(((NestableNode)extractionNode).getChildren());
        }
        return extractionChildren;
    }

    public String toString() {
        return "(DOMSELECTOR: " + this.selectorExpression + ")";
    }
}

