/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.fragment;

import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementAndAttributeNameFragmentSpec
implements IFragmentSpec {
    private final String elementName;
    private final String attributeName;
    private final String attributeValue;
    private final boolean returnOnlyChildren;

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue) {
        this(elementName, attributeName, attributeValue, false);
    }

    public ElementAndAttributeNameFragmentSpec(String elementName, String attributeName, String attributeValue, boolean returnOnlyChildren) {
        Validate.isTrue(StringUtils.isEmpty(elementName) == false || StringUtils.isEmpty(attributeName) == false, "Either element name of attribute name must not be null or empty");
        if (!StringUtils.isEmpty(attributeName).booleanValue()) {
            Validate.notEmpty(attributeValue, "Fragment attribute value cannot be null or empty");
        }
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.returnOnlyChildren = returnOnlyChildren;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public boolean isReturnOnlyChildren() {
        return this.returnOnlyChildren;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        List<Node> extraction = DOMUtils.extractFragmentByElementAndAttributeValue(nodes, this.elementName, this.attributeName, this.attributeValue);
        if (!this.returnOnlyChildren) {
            return extraction;
        }
        ArrayList<Node> extractionChildren = new ArrayList<Node>();
        for (Node extractionNode : extraction) {
            if (extractionNode == null) continue;
            if (!(extractionNode instanceof NestableNode)) {
                throw new TemplateProcessingException("Cannot correctly retrieve children of node selected by fragment spec with element name \"" + this.elementName + "\", attribute name \"" + this.attributeName + "\" and attribute value \"" + this.attributeValue + "\". Node is not a nestable node (" + extractionNode.getClass().getSimpleName() + ").");
            }
            extractionChildren.addAll(((NestableNode)extractionNode).getChildren());
        }
        return extractionChildren;
    }

    public String toString() {
        return "(ELEMENT: " + this.elementName + " | ATTRIBUTE: " + this.attributeName + "=\"" + this.attributeValue + "\")";
    }
}

