/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.util.MessageResolutionUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractProcessor
implements IProcessor {
    protected String getMessage(Arguments arguments, String messageKey, Object[] messageParameters) {
        String templateMessage = MessageResolutionUtils.resolveMessageForTemplate(arguments, messageKey, messageParameters, false);
        if (templateMessage != null) {
            return templateMessage;
        }
        String processorMessage = MessageResolutionUtils.resolveMessageForClass(arguments.getConfiguration(), this.getClass(), arguments.getContext().getLocale(), messageKey, messageParameters, false);
        if (processorMessage != null) {
            return processorMessage;
        }
        return MessageResolutionUtils.getAbsentMessageRepresentation(messageKey, arguments.getContext().getLocale());
    }

    protected String getMessageForTemplate(Arguments arguments, String messageKey, Object[] messageParameters) {
        return MessageResolutionUtils.resolveMessageForTemplate(arguments, messageKey, messageParameters);
    }

    protected String getMessageForProcessor(Arguments arguments, String messageKey, Object[] messageParameters) {
        Validate.notNull(arguments.getContext().getLocale(), "Locale in context cannot be null");
        return MessageResolutionUtils.resolveMessageForClass(arguments.getConfiguration(), this.getClass(), arguments.getContext().getLocale(), messageKey, messageParameters);
    }

    public abstract int getPrecedence();

    public int compareTo(IProcessor o) {
        int otherPrecedence;
        if (o == null) {
            return 1;
        }
        if (!(o instanceof AbstractProcessor)) {
            int result = o.compareTo(this);
            return -1 * result;
        }
        int thisPrecedence = this.getPrecedence();
        if (thisPrecedence > (otherPrecedence = ((AbstractProcessor)o).getPrecedence())) {
            return 1;
        }
        if (thisPrecedence < otherPrecedence) {
            return -1;
        }
        return 0;
    }

    public final ProcessorResult process(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        try {
            return this.doProcess(arguments, processorMatchingContext, node);
        }
        catch (TemplateProcessingException e) {
            if (!e.hasTemplateName()) {
                e.setTemplateName(node.getDocumentName());
            }
            if (!e.hasLineNumber()) {
                e.setLineNumber(node.getLineNumber());
            }
            throw e;
        }
        catch (Exception e) {
            TemplateProcessingException exception = new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", node.getDocumentName(), node.getLineNumber(), e);
            throw exception;
        }
    }

    protected abstract ProcessorResult doProcess(Arguments var1, ProcessorMatchingContext var2, Node var3);
}

