/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorResult {
    private static final Map<String, Object> EMPTY_VARIABLES = Collections.unmodifiableMap(new HashMap());
    public static final ProcessorResult OK = new ProcessorResult(null, false, false, null, false);
    private final Map<String, Object> localVariables;
    private final boolean processOnlyElementNodes;
    private final boolean processOnlyElementNodesSet;
    private final Object selectionTarget;
    private final boolean selectionTargetSet;

    public static ProcessorResult ok() {
        return OK;
    }

    public static ProcessorResult setLocalVariables(Map<String, Object> localVariables) {
        return new ProcessorResult(localVariables, false, false, null, false);
    }

    public static ProcessorResult setProcessOnlyElementNodes(boolean processOnlyElementNodes) {
        return new ProcessorResult(null, processOnlyElementNodes, true, null, false);
    }

    public static ProcessorResult setLocalVariablesAndProcessOnlyElementNodes(Map<String, Object> localVariables, boolean processOnlyElementNodes) {
        return new ProcessorResult(localVariables, processOnlyElementNodes, true, null, false);
    }

    public static ProcessorResult setSelectionTarget(Object selectionTarget) {
        return new ProcessorResult(null, false, false, selectionTarget, true);
    }

    public static ProcessorResult setLocalVariablesAndSelectionTarget(Map<String, Object> localVariables, Object selectionTarget) {
        return new ProcessorResult(localVariables, false, false, selectionTarget, true);
    }

    private ProcessorResult(Map<String, Object> localVariables, boolean processOnlyElementNodes, boolean processOnlyElementNodesSet, Object selectionTarget, boolean selectionTargetSet) {
        this.localVariables = localVariables == null ? EMPTY_VARIABLES : Collections.unmodifiableMap(new HashMap<String, Object>(localVariables));
        this.processOnlyElementNodes = processOnlyElementNodes;
        this.processOnlyElementNodesSet = processOnlyElementNodesSet;
        this.selectionTarget = selectionTarget;
        this.selectionTargetSet = selectionTargetSet;
    }

    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    public Map<String, Object> getLocalVariables() {
        return this.localVariables;
    }

    public boolean getProcessOnlyElementNodes() {
        return this.processOnlyElementNodes;
    }

    public boolean isProcessOnlyElementNodesSet() {
        return this.processOnlyElementNodesSet;
    }

    public Object getSelectionTarget() {
        return this.selectionTarget;
    }

    public boolean isSelectionTargetSet() {
        return this.selectionTargetSet;
    }

    public boolean isOK() {
        return (this.localVariables == null || this.localVariables.size() == 0) && !this.processOnlyElementNodesSet && !this.selectionTargetSet;
    }

    public Arguments computeNewArguments(Arguments arguments) {
        if (this.isOK()) {
            return arguments;
        }
        if (this.localVariables != null && this.localVariables.size() > 0) {
            if (this.processOnlyElementNodesSet) {
                return arguments.addLocalVariablesAndProcessOnlyElementNodes(this.localVariables, this.processOnlyElementNodes);
            }
            if (this.selectionTargetSet) {
                return arguments.addLocalVariablesAndSelectionTarget(this.localVariables, this.selectionTarget);
            }
            return arguments.addLocalVariables(this.localVariables);
        }
        if (this.processOnlyElementNodesSet) {
            return arguments.setProcessOnlyElementNodes(this.processOnlyElementNodes);
        }
        if (this.selectionTargetSet) {
            return arguments.setSelectionTarget(this.selectionTarget);
        }
        return arguments;
    }
}

