/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.AttributeNameProcessorMatcher;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttrProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IAttributeNameProcessorMatcher matcher;

    public AbstractAttrProcessor(String attributeName) {
        this(new AttributeNameProcessorMatcher(attributeName));
    }

    public AbstractAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public final IProcessorMatcher<? extends Element> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        if (this.logger.isTraceEnabled()) {
            String attributeName = this.matcher.getAttributeName(processorMatchingContext);
            String attributeValue = ((Element)node).getAttributeValue(attributeName);
            this.logger.trace("[THYMELEAF][{}][{}] Processing attribute \"{}\" with value \"{}\" in element \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), attributeName, attributeValue == null ? "" : attributeValue, ((Element)node).getNormalizedName()});
        }
        return this.processAttribute(arguments, (Element)node, this.matcher.getAttributeName(processorMatchingContext));
    }

    protected abstract ProcessorResult processAttribute(Arguments var1, Element var2, String var3);
}

