/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeModifierAttrProcessor
extends AbstractAttrProcessor {
    public AbstractAttributeModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public AbstractAttributeModifierAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        Map<String, String> modifiedAttributeValues = this.getModifiedAttributeValues(arguments, element, attributeName);
        if (modifiedAttributeValues == null) {
            throw new TemplateProcessingException("Null new attribute value map specified for: \"" + attributeName + "\"");
        }
        for (Map.Entry<String, String> modifiedAttributeEntry : modifiedAttributeValues.entrySet()) {
            String modifiedAttributeName = modifiedAttributeEntry.getKey();
            String modifiedAttributeValue = modifiedAttributeEntry.getValue();
            String currentAttributeValue = element.getAttributeValue(modifiedAttributeName);
            ModificationType modificationType = this.getModificationType(arguments, element, attributeName, modifiedAttributeName);
            if (currentAttributeValue == null) {
                currentAttributeValue = "";
            }
            if (modifiedAttributeValue == null) {
                modifiedAttributeValue = "";
            }
            switch (modificationType) {
                case SUBSTITUTION: {
                    break;
                }
                case APPEND: {
                    modifiedAttributeValue = currentAttributeValue + modifiedAttributeValue;
                    break;
                }
                case APPEND_WITH_SPACE: {
                    if (!currentAttributeValue.equals("")) {
                        modifiedAttributeValue = currentAttributeValue + " " + modifiedAttributeValue;
                        break;
                    }
                    modifiedAttributeValue = currentAttributeValue + modifiedAttributeValue;
                    break;
                }
                case PREPEND: {
                    modifiedAttributeValue = modifiedAttributeValue + currentAttributeValue;
                    break;
                }
                case PREPEND_WITH_SPACE: {
                    modifiedAttributeValue = !currentAttributeValue.equals("") ? modifiedAttributeValue + " " + currentAttributeValue : modifiedAttributeValue + currentAttributeValue;
                }
            }
            boolean removeAttributeIfEmpty = this.removeAttributeIfEmpty(arguments, element, attributeName, modifiedAttributeName);
            if (modifiedAttributeValue.equals("") && removeAttributeIfEmpty) {
                element.removeAttribute(modifiedAttributeName);
                continue;
            }
            element.setAttribute(modifiedAttributeName, modifiedAttributeValue);
        }
        this.doAdditionalProcess(arguments, element, attributeName);
        element.removeAttribute(attributeName);
        if (this.recomputeProcessorsAfterExecution(arguments, element, attributeName)) {
            element.setRecomputeProcessorsImmediately(true);
        }
        return ProcessorResult.OK;
    }

    protected abstract Map<String, String> getModifiedAttributeValues(Arguments var1, Element var2, String var3);

    protected abstract ModificationType getModificationType(Arguments var1, Element var2, String var3, String var4);

    protected abstract boolean removeAttributeIfEmpty(Arguments var1, Element var2, String var3, String var4);

    protected abstract boolean recomputeProcessorsAfterExecution(Arguments var1, Element var2, String var3);

    protected void doAdditionalProcess(Arguments arguments, Element element, String attributeName) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModificationType {
        SUBSTITUTION,
        APPEND,
        APPEND_WITH_SPACE,
        PREPEND,
        PREPEND_WITH_SPACE;

    }
}

