/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.FragmentAndTarget;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

public abstract class AbstractFragmentHandlingAttrProcessor
extends AbstractAttrProcessor {
    public AbstractFragmentHandlingAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public AbstractFragmentHandlingAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        boolean substituteInclusionNode;
        String attributeValue = element.getAttributeValue(attributeName);
        FragmentAndTarget fragmentAndTarget = this.getFragmentAndTarget(arguments, element, attributeName, attributeValue, substituteInclusionNode = this.getSubstituteInclusionNode(arguments, element, attributeName, attributeValue));
        List<Node> fragmentNodes = fragmentAndTarget.extractFragment(arguments.getConfiguration(), arguments, arguments.getTemplateRepository());
        if (fragmentNodes == null) {
            throw new TemplateProcessingException("Cannot correctly process \"" + attributeName + "\" attribute. " + "Fragment specification \"" + attributeValue + "\" matched null.");
        }
        element.clearChildren();
        element.removeAttribute(attributeName);
        if (substituteInclusionNode) {
            element.setChildren(fragmentNodes);
            element.getParent().extractChild(element);
        } else {
            for (Node fragmentNode : fragmentNodes) {
                element.addChild(fragmentNode);
            }
        }
        return ProcessorResult.OK;
    }

    protected abstract boolean getSubstituteInclusionNode(Arguments var1, Element var2, String var3, String var4);

    protected abstract FragmentAndTarget getFragmentAndTarget(Arguments var1, Element var2, String var3, String var4, boolean var5);
}

