/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import java.util.Collections;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractFragmentElementProcessor
extends AbstractElementProcessor {
    private static final String DOM_SELECTOR_EXPRESSION_PREFIX = "{dom_selector}";

    public AbstractFragmentElementProcessor(String elementName) {
        super(elementName);
    }

    public AbstractFragmentElementProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    @Override
    public final ProcessorResult processElement(Arguments arguments, Element element) {
        boolean substituteInclusionNode = this.getSubstituteInclusionNode(arguments, element);
        List<Node> newNodes = this.getNewNodes(arguments, element, substituteInclusionNode);
        element.clearChildren();
        for (Node newNode : newNodes) {
            element.addChild(newNode);
        }
        if (!substituteInclusionNode) {
            return ProcessorResult.OK;
        }
        element.getParent().extractChild(element);
        return ProcessorResult.OK;
    }

    private final List<Node> getNewNodes(Arguments arguments, Element element, boolean substituteInclusionNode) {
        AbstractFragmentSpec fragmentSpec = this.getFragmentSpec(arguments, element);
        if (fragmentSpec == null) {
            throw new TemplateProcessingException("Null value for \"" + element.getOriginalName() + "\" fragment specification not allowed");
        }
        Node fragmentNode = AbstractFragmentElementProcessor.getFragment(arguments, element, fragmentSpec);
        if (fragmentNode == null) {
            throw new TemplateProcessingException("An error happened during parsing of include: \"" + element.getOriginalName() + "\": fragment node is null");
        }
        try {
            if (substituteInclusionNode) {
                return Collections.singletonList(fragmentNode);
            }
            if (!(fragmentNode instanceof NestableNode)) {
                throw new TemplateProcessingException("An error happened during parsing of include: \"" + element.getOriginalName() + "\": selected fragment has no children " + "and therefore is not suitable for use in an inclusion operation -- maybe a substitution operation should be used instead?");
            }
            return ((NestableNode)fragmentNode).getChildren();
        }
        catch (Exception e) {
            throw new TemplateProcessingException("An error happened during parsing of include: \"" + element.getOriginalName() + "\"", e);
        }
    }

    private static Node getFragment(Arguments arguments, Element element, AbstractFragmentSpec fragmentSpec) {
        String fragmentTemplateName = fragmentSpec.getFragmentTemplateName();
        String templateName = arguments.getTemplateResolution().getTemplateName();
        if (templateName.equals(fragmentTemplateName)) {
            throw new TemplateProcessingException("Template \"" + templateName + "\" references itself from a " + "\"" + element.getOriginalName() + "\" element, which is forbidden.");
        }
        try {
            TemplateProcessingParameters fragmentTemplateProcessingParameters = new TemplateProcessingParameters(arguments.getConfiguration(), fragmentTemplateName, arguments.getContext());
            Template parsedTemplate = arguments.getTemplateRepository().getTemplate(fragmentTemplateProcessingParameters);
            Node fragmentNode = null;
            if (fragmentSpec instanceof NamedFragmentSpec) {
                NamedFragmentSpec namedFragmentSpec = (NamedFragmentSpec)fragmentSpec;
                String fragmentElementName = namedFragmentSpec.getFragmentElementName();
                String fragmentAttributeName = namedFragmentSpec.getFragmentAttributeName();
                String fragmentAttributeValue = namedFragmentSpec.getFragmentAttributeValue();
                fragmentNode = DOMUtils.extractFragmentByAttributeValue(parsedTemplate.getDocument(), fragmentElementName, fragmentAttributeName, fragmentAttributeValue);
                if (fragmentNode == null) {
                    throw new TemplateProcessingException("Fragment \"" + fragmentAttributeValue + "\" in template \"" + fragmentTemplateName + "\" could not be found");
                }
            } else if (fragmentSpec instanceof CompleteTemplateFragmentSpec) {
                fragmentNode = parsedTemplate.getDocument();
                if (fragmentNode == null) {
                    throw new TemplateProcessingException("Root node in template \"" + fragmentTemplateName + "\" could not be found");
                }
            } else if (fragmentSpec instanceof DOMSelectorFragmentSpec) {
                List<Node> selectedNodes;
                DOMSelectorFragmentSpec domSelectorFragmentSpec = (DOMSelectorFragmentSpec)fragmentSpec;
                String domSelectorExpression = domSelectorFragmentSpec.getSelectorExpression();
                DOMSelector selector = null;
                ICache<String, Object> expressionCache = null;
                ICacheManager cacheManager = arguments.getConfiguration().getCacheManager();
                if (cacheManager != null && (expressionCache = cacheManager.getExpressionCache()) != null) {
                    selector = (DOMSelector)expressionCache.get(DOM_SELECTOR_EXPRESSION_PREFIX + domSelectorExpression);
                }
                if (selector == null) {
                    selector = new DOMSelector(domSelectorExpression);
                    if (expressionCache != null) {
                        expressionCache.put(DOM_SELECTOR_EXPRESSION_PREFIX + domSelectorExpression, selector);
                    }
                }
                if ((selectedNodes = selector.select(parsedTemplate.getDocument().getChildren())) == null || selectedNodes.size() == 0) {
                    throw new TemplateProcessingException("No result for DOM selector expression \"" + domSelectorExpression + "\" in template \"" + fragmentTemplateName + "\" could be found");
                }
                fragmentNode = selectedNodes.get(0);
            }
            return fragmentNode;
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("An error happened during parsing of template: \"" + fragmentTemplateName + "\"", e);
        }
    }

    protected abstract boolean getSubstituteInclusionNode(Arguments var1, Element var2);

    protected abstract AbstractFragmentSpec getFragmentSpec(Arguments var1, Element var2);

    protected static final class DOMSelectorFragmentSpec
    extends AbstractFragmentSpec {
        private final String selectorExpression;

        public DOMSelectorFragmentSpec(String fragmentTemplateName, String selectorExpression) {
            super(fragmentTemplateName);
            Validate.notEmpty(selectorExpression, "Selector expression cannot be null or empty");
            this.selectorExpression = selectorExpression;
        }

        public String getSelectorExpression() {
            return this.selectorExpression;
        }
    }

    protected static final class CompleteTemplateFragmentSpec
    extends AbstractFragmentSpec {
        public CompleteTemplateFragmentSpec(String fragmentTemplateName) {
            super(fragmentTemplateName);
        }
    }

    protected static final class NamedFragmentSpec
    extends AbstractFragmentSpec {
        private final String fragmentElementName;
        private final String fragmentAttributeName;
        private final String fragmentAttributeValue;

        public NamedFragmentSpec(String fragmentTemplateName, String fragmentAttributeName, String fragmentAttributeValue) {
            this(fragmentTemplateName, null, fragmentAttributeName, fragmentAttributeValue);
        }

        public NamedFragmentSpec(String fragmentTemplateName, String fragmentElementName, String fragmentAttributeName, String fragmentAttributeValue) {
            super(fragmentTemplateName);
            Validate.notEmpty(fragmentAttributeName, "Fragment attribute name cannot be null or empty");
            Validate.notEmpty(fragmentAttributeValue, "Fragment attribute value cannot be null or empty");
            this.fragmentElementName = fragmentElementName;
            this.fragmentAttributeName = fragmentAttributeName;
            this.fragmentAttributeValue = fragmentAttributeValue;
        }

        public String getFragmentElementName() {
            return this.fragmentElementName;
        }

        public String getFragmentAttributeName() {
            return this.fragmentAttributeName;
        }

        public String getFragmentAttributeValue() {
            return this.fragmentAttributeValue;
        }
    }

    protected static abstract class AbstractFragmentSpec {
        private final String fragmentTemplateName;

        public AbstractFragmentSpec(String fragmentTemplateName) {
            Validate.notEmpty(fragmentTemplateName, "Fragment template name cannot be null or empty");
            this.fragmentTemplateName = fragmentTemplateName;
        }

        public String getFragmentTemplateName() {
            return this.fragmentTemplateName;
        }
    }
}

